/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.independentsamples;

import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LevenesIndependentSamples {
    public static boolean testVariances(TransposeDataCollection transposeDataCollection, double aLevel) {
        int n = 0;
        int k = transposeDataCollection.size();
        if (k <= 1) {
            throw new IllegalArgumentException("The collection must contain observations from at least 2 groups.");
        }
        HashMap<Object, Integer> nj = new HashMap<Object, Integer>();
        HashMap<Object, Double> Yjmean = new HashMap<Object, Double>();
        for (Map.Entry<Object, FlatDataCollection> entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = entry.getValue();
            int tmp = flatDataCollection.size();
            if (tmp == 0) {
                throw new IllegalArgumentException("The number of observations in each group but be larger than 0.");
            }
            nj.put(j, tmp);
            n += tmp;
            Yjmean.put(j, Descriptives.sum(flatDataCollection) / (double)tmp);
        }
        double zdotdot = 0.0;
        HashMap<Object, Double> zjdot = new HashMap<Object, Double>();
        HashMap zji = new HashMap();
        for (Map.Entry<Object, FlatDataCollection> entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = entry.getValue();
            zji.put(j, new HashMap());
            double zjdotSum = 0.0;
            int i = 0;
            Iterator<Double> it = flatDataCollection.iteratorDouble();
            while (it.hasNext()) {
                Double Yji = it.next();
                double tmp = Math.abs(Yji - (Double)Yjmean.get(j));
                ((Map)zji.get(j)).put(i, tmp);
                zdotdot += tmp;
                zjdotSum += tmp;
                ++i;
            }
            zjdot.put(j, zjdotSum / (double)((Integer)nj.get(j)).intValue());
        }
        zdotdot /= (double)n;
        double numerator = 0.0;
        double denominator = 0.0;
        for (Map.Entry<Object, FlatDataCollection> entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = entry.getValue();
            numerator += (double)((Integer)nj.get(j)).intValue() * Math.pow((Double)zjdot.get(j) - zdotdot, 2.0);
            int len = flatDataCollection.size();
            for (int i = 0; i < len; ++i) {
                denominator += Math.pow((Double)((Map)zji.get(j)).get(i) - (Double)zjdot.get(j), 2.0);
            }
        }
        if (denominator == 0.0) {
            throw new IllegalArgumentException("The values of the input collection are invalid.");
        }
        double W = (double)(n - k) / ((double)k - 1.0) * (numerator / denominator);
        boolean rejectH0 = LevenesIndependentSamples.checkCriticalValue(W, n, k, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, int n, int k, double aLevel) {
        double probability = ContinuousDistributions.fCdf(score, k - 1, n - k);
        boolean rejectH0 = false;
        if (probability <= aLevel || probability >= 1.0 - aLevel) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

