/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.relatedsamples;

import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TransposeDataList;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class KendallTauCorrelation {
    public static double calculateCorrelation(TransposeDataList transposeDataList) {
        Object[] keys = transposeDataList.keySet().toArray();
        if (keys.length != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        Object keyX = keys[0];
        Object keyY = keys[1];
        FlatDataList flatDataListX = transposeDataList.get(keyX);
        FlatDataList flatDataListY = transposeDataList.get(keyY);
        int n = flatDataListX.size();
        if (n <= 0 || n != flatDataListY.size()) {
            throw new IllegalArgumentException("The number of observations in each group must be equal and larger than 0.");
        }
        int numberOfConcordant = 0;
        int numberOfDisconcordant = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double yj;
                double yi;
                double xj;
                double xi = flatDataListX.getDouble(i);
                double sign = (xi - (xj = flatDataListX.getDouble(j).doubleValue())) * ((yi = flatDataListY.getDouble(i).doubleValue()) - (yj = flatDataListY.getDouble(j).doubleValue()));
                if (sign > 0.0) {
                    ++numberOfConcordant;
                    continue;
                }
                if (!(sign < 0.0)) continue;
                ++numberOfDisconcordant;
            }
        }
        double R = (double)((numberOfConcordant /= 2) - (numberOfDisconcordant /= 2)) / ((double)n * ((double)n - 1.0) / 2.0);
        return R;
    }

    public static boolean test(TransposeDataList transposeDataList, boolean is_twoTailed, double aLevel) {
        if (transposeDataList.isEmpty()) {
            return false;
        }
        double KendallTauCorrelation2 = KendallTauCorrelation.calculateCorrelation(transposeDataList);
        Object firstKey = transposeDataList.keySet().iterator().next();
        int n = transposeDataList.get(firstKey).size();
        double pvalue = KendallTauCorrelation.scoreToPvalue(KendallTauCorrelation2, n);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int n) {
        double variance = 2.0 * (2.0 * (double)n + 5.0) / (9.0 * (double)n * ((double)n - 1.0));
        double Z = score / Math.sqrt(variance);
        return ContinuousDistributions.gaussCdf(Z);
    }
}

