/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.onesample;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.descriptivestatistics.Ranks;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.Iterator;
import java.util.Map;

public class WilcoxonOneSample {
    public static double getPvalue(FlatDataCollection flatDataCollection, double median) {
        int n = 0;
        AssociativeArray Di = new AssociativeArray();
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            double delta = it.next() - median;
            if (delta == 0.0) continue;
            Object key = "+";
            if (delta < 0.0) {
                key = "-";
            }
            Di.put((String)key + String.valueOf(n), Math.abs(delta));
            ++n;
        }
        if (n <= 0) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        Ranks.getRanksFromValues(Di);
        double W = 0.0;
        for (Map.Entry entry : Di.entrySet()) {
            String key = entry.getKey().toString();
            Double rank = TypeInference.toDouble(entry.getValue());
            if (key.charAt(0) != '+') continue;
            W += rank.doubleValue();
        }
        double pvalue = WilcoxonOneSample.scoreToPvalue(W, n);
        return pvalue;
    }

    public static boolean test(FlatDataCollection flatDataCollection, double median, boolean is_twoTailed, double aLevel) {
        double pvalue = WilcoxonOneSample.getPvalue(flatDataCollection, median);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int n) {
        double mean = (double)n * ((double)n + 1.0) / 4.0;
        double variable = (double)n * ((double)n + 1.0) * (2.0 * (double)n + 1.0) / 24.0;
        double z = (score - mean) / Math.sqrt(variable);
        return ContinuousDistributions.gaussCdf(z);
    }
}

