/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.onesample;

import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.Iterator;

public class SignOneSample {
    public static double getPvalue(FlatDataCollection flatDataCollection, double median) {
        int n = flatDataCollection.size();
        if (n <= 0) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        int Tplus = 0;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            double v = it.next();
            if (Math.abs(v - median) < 1.0E-7 || !(v > median)) continue;
            ++Tplus;
        }
        double pvalue = SignOneSample.scoreToPvalue(Tplus, n);
        return pvalue;
    }

    public static boolean test(FlatDataCollection flatDataCollection, double median, boolean is_twoTailed, double aLevel) {
        double pvalue = SignOneSample.getPvalue(flatDataCollection, median);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int n) {
        double mean = (double)n / 2.0;
        double variable = (double)n / 4.0;
        double z = (score - mean) / Math.sqrt(variable);
        return ContinuousDistributions.gaussCdf(z);
    }
}

