/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.independentsamples;

import com.datumbox.framework.common.dataobjects.DataTable2D;
import com.datumbox.framework.common.dataobjects.TransposeDataList;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.Iterator;
import java.util.TreeSet;

public class KolmogorovSmirnovIndependentSamples {
    public static boolean test(TransposeDataList transposeDataList, boolean is_twoTailed, double aLevel) {
        int k = transposeDataList.size();
        if (k != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        Object[] keys = transposeDataList.keySet().toArray();
        TreeSet<Double> allUniqueValues = new TreeSet<Double>();
        for (int j = 0; j < k; ++j) {
            Iterator<Double> it = transposeDataList.get(keys[j]).iteratorDouble();
            while (it.hasNext()) {
                allUniqueValues.add(it.next());
            }
        }
        DataTable2D distributionAndValue2Probability = new DataTable2D();
        for (int j = 0; j < k; ++j) {
            Object keyj = keys[j];
            int nj = transposeDataList.get(keyj).size();
            if (nj <= 0) {
                throw new IllegalArgumentException("The number of observations in each group but be larger than 0.");
            }
            int rank = 1;
            Iterator iterator = allUniqueValues.iterator();
            while (iterator.hasNext()) {
                Double value;
                Double objValue = value = (Double)iterator.next();
                if (!transposeDataList.get(keyj).contains(objValue)) {
                    distributionAndValue2Probability.put2d(keyj, objValue, ((double)rank - 1.0) / (double)nj);
                    continue;
                }
                if (distributionAndValue2Probability.get2d(keyj, objValue) == null) {
                    distributionAndValue2Probability.put2d(keyj, objValue, (double)rank / (double)nj);
                }
                ++rank;
            }
        }
        double maxDelta = 0.0;
        for (Object key : distributionAndValue2Probability.get(keys[0]).keySet()) {
            double v1 = distributionAndValue2Probability.get(keys[0]).getDouble(key);
            double v2 = distributionAndValue2Probability.get(keys[1]).getDouble(key);
            double delta = Math.abs(v2 - v1);
            if (!(delta > maxDelta)) continue;
            maxDelta = delta;
        }
        int n1 = transposeDataList.get(keys[0]).size();
        int n2 = transposeDataList.get(keys[1]).size();
        boolean rejectH0 = KolmogorovSmirnovIndependentSamples.checkCriticalValue(maxDelta, is_twoTailed, n1, n2, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, boolean is_twoTailed, int n1, int n2, double aLevel) {
        boolean rejected = false;
        double criticalValue = KolmogorovSmirnovIndependentSamples.calculateCriticalValue(is_twoTailed, n1, n2, aLevel);
        if (score > criticalValue) {
            rejected = true;
        }
        return rejected;
    }

    protected static double calculateCriticalValue(boolean is_twoTailed, int n1, int n2, double aLevel) {
        double sign;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        double one_minus_a = 1.0 - a;
        double Ka = 1.36;
        int direction = 1;
        if (ContinuousDistributions.kolmogorov(Ka) > one_minus_a) {
            direction = -1;
        }
        for (int i = 0; i < 110 && !((sign = (one_minus_a - ContinuousDistributions.kolmogorov(Ka += (double)direction * 0.01)) * (double)direction) <= 0.0); ++i) {
        }
        double criticalValue = Ka * Math.sqrt(((double)n1 + (double)n2) / (double)(n1 * n2));
        return criticalValue;
    }
}

