/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.independentsamples;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.DataTable2D;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.HashMap;
import java.util.Map;

public class Chisquare {
    public static AssociativeArray getScore(DataTable2D dataTable) {
        AssociativeArray row;
        Object i;
        HashMap<Object, Double> XdotJ = new HashMap<Object, Double>();
        HashMap<Object, Double> XIdot = new HashMap<Object, Double>();
        double Xdotdot = 0.0;
        for (Map.Entry<Object, AssociativeArray> entry1 : dataTable.entrySet()) {
            Object i2 = entry1.getKey();
            AssociativeArray row2 = entry1.getValue();
            for (Map.Entry<Object, Object> entry : row2.entrySet()) {
                Object j = entry.getKey();
                Object value = entry.getValue();
                double v = TypeInference.toDouble(value);
                if (!XdotJ.containsKey(j)) {
                    XdotJ.put(j, v);
                } else {
                    XdotJ.put(j, (Double)XdotJ.get(j) + v);
                }
                if (!XIdot.containsKey(i2)) {
                    XIdot.put(i2, v);
                } else {
                    XIdot.put(i2, (Double)XIdot.get(i2) + v);
                }
                Xdotdot += v;
            }
        }
        int k = XdotJ.size();
        int n = XIdot.size();
        double ChisquareScore = 0.0;
        if (k == 2 && n == 2) {
            for (Map.Entry<Object, Object> entry : dataTable.entrySet()) {
                i = entry.getKey();
                row = (AssociativeArray)entry.getValue();
                for (Map.Entry<Object, Object> entry2 : row.entrySet()) {
                    Object j = entry2.getKey();
                    Object value = entry2.getValue();
                    double v = TypeInference.toDouble(value);
                    double eij = (Double)XIdot.get(i) * (Double)XdotJ.get(j) / Xdotdot;
                    if (eij == 0.0) continue;
                    ChisquareScore += Math.pow(Math.abs(v - eij) - 0.5, 2.0) / eij;
                }
            }
        } else {
            for (Map.Entry<Object, Object> entry : dataTable.entrySet()) {
                i = entry.getKey();
                row = (AssociativeArray)entry.getValue();
                for (Map.Entry<Object, Object> entry2 : row.entrySet()) {
                    Object j = entry2.getKey();
                    Object value = entry2.getValue();
                    double v = TypeInference.toDouble(value);
                    double eij = (Double)XIdot.get(i) * (Double)XdotJ.get(j) / Xdotdot;
                    ChisquareScore += Math.pow(v - eij, 2.0) / eij;
                }
            }
        }
        AssociativeArray result = new AssociativeArray();
        result.put("k", k);
        result.put("n", n);
        result.put("score", ChisquareScore);
        return result;
    }

    public static double getScoreValue(DataTable2D dataTable) {
        AssociativeArray result = Chisquare.getScore(dataTable);
        double score = result.getDouble("score");
        return score;
    }

    public static double getPvalue(DataTable2D dataTable) {
        AssociativeArray result = Chisquare.getScore(dataTable);
        double score = result.getDouble("score");
        int n = result.getDouble("n").intValue();
        int k = result.getDouble("k").intValue();
        double pvalue = Chisquare.scoreToPvalue(score, n, k);
        return pvalue;
    }

    public static boolean test(DataTable2D dataTable, double aLevel) {
        double pvalue = Chisquare.getPvalue(dataTable);
        boolean rejectH0 = false;
        if (pvalue <= aLevel) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int n, int k) {
        return 1.0 - ContinuousDistributions.chisquareCdf(score, (n - 1) * (k - 1));
    }
}

