/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.distributions;

import com.datumbox.framework.common.utilities.RandomGenerator;
import org.apache.commons.math3.distribution.MultivariateNormalDistribution;

public class ContinuousDistributions {
    public static double chisquareCdf(double x, int df) {
        if (df <= 0) {
            throw new IllegalArgumentException("The degrees of freedom need to be positive.");
        }
        return ContinuousDistributions.gammaCdf(x / 2.0, (double)df / 2.0);
    }

    public static double gaussCdf(double z) {
        double p;
        if (z == 0.0) {
            p = 0.0;
        } else {
            double y = Math.abs(z) / 2.0;
            if (y >= 3.0) {
                p = 1.0;
            } else if (y < 1.0) {
                double w = y * y;
                p = ((((((((1.24818987E-4 * w - 0.001075204047) * w + 0.005198775019) * w - 0.019198292004) * w + 0.059054035642) * w - 0.151968751364) * w + 0.319152932694) * w - 0.5319230073) * w + 0.797884560593) * y * 2.0;
            } else {
                p = (((((((((((((-4.5255659E-5 * (y -= 2.0) + 1.5252929E-4) * y - 1.9538132E-5) * y - 6.76904986E-4) * y + 0.001390604284) * y - 7.9462082E-4) * y - 0.002034254874) * y + 0.006549791214) * y - 0.010557625006) * y + 0.011630447319) * y - 0.009279453341) * y + 0.005353579108) * y - 0.002141268741) * y + 5.35310849E-4) * y + 0.999936657524;
            }
        }
        if (z > 0.0) {
            return (p + 1.0) / 2.0;
        }
        return (1.0 - p) / 2.0;
    }

    public static double gamma(double x) {
        return Math.exp(ContinuousDistributions.logGamma(x));
    }

    public static double logGamma(double Z) {
        double S = 1.0 + 76.18009173 / Z - 86.50532033 / (Z + 1.0) + 24.01409822 / (Z + 2.0) - 1.231739516 / (Z + 3.0) + 0.00120858003 / (Z + 4.0) - 5.36382E-6 / (Z + 5.0);
        double LG = (Z - 0.5) * Math.log(Z + 4.5) - (Z + 4.5) + Math.log(S * 2.50662827465);
        return LG;
    }

    protected static double betinc(double x, double A, double B) {
        double A0 = 0.0;
        double B0 = 1.0;
        double A1 = 1.0;
        double B1 = 1.0;
        double M9 = 0.0;
        double A2 = 0.0;
        while (Math.abs((A1 - A2) / A1) > 1.0E-5) {
            A2 = A1;
            double C9 = -(A + M9) * (A + B + M9) * x / (A + 2.0 * M9) / (A + 2.0 * M9 + 1.0);
            A0 = A1 + C9 * A0;
            B0 = B1 + C9 * B0;
            C9 = (M9 += 1.0) * (B - M9) * x / (A + 2.0 * M9 - 1.0) / (A + 2.0 * M9);
            A1 = A0 + C9 * A1;
            B1 = B0 + C9 * B1;
            A0 /= B1;
            B0 /= B1;
            A1 /= B1;
            B1 = 1.0;
        }
        return A1 / A;
    }

    public static double studentsCdf(double x, int df) {
        if (df <= 0) {
            throw new IllegalArgumentException("The degrees of freedom need to be positive.");
        }
        double A = (double)df / 2.0;
        double S = A + 0.5;
        double Z = (double)df / ((double)df + x * x);
        double BT = Math.exp(ContinuousDistributions.logGamma(S) - ContinuousDistributions.logGamma(0.5) - ContinuousDistributions.logGamma(A) + A * Math.log(Z) + 0.5 * Math.log(1.0 - Z));
        double betacdf = Z < (A + 1.0) / (S + 2.0) ? BT * ContinuousDistributions.betinc(Z, A, 0.5) : 1.0 - BT * ContinuousDistributions.betinc(1.0 - Z, 0.5, A);
        double tcdf = x < 0.0 ? betacdf / 2.0 : 1.0 - betacdf / 2.0;
        return tcdf;
    }

    public static double exponentialCdf(double x, double lamda) {
        if (x < 0.0 || lamda <= 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double probability = 1.0 - Math.exp(-lamda * x);
        return probability;
    }

    public static double betaCdf(double x, double a, double b) {
        if (x < 0.0 || a <= 0.0 || b <= 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double Bcdf = 0.0;
        if (x == 0.0) {
            return Bcdf;
        }
        if (x >= 1.0) {
            Bcdf = 1.0;
            return Bcdf;
        }
        double S = a + b;
        double BT = Math.exp(ContinuousDistributions.logGamma(S) - ContinuousDistributions.logGamma(b) - ContinuousDistributions.logGamma(a) + a * Math.log(x) + b * Math.log(1.0 - x));
        Bcdf = x < (a + 1.0) / (S + 2.0) ? BT * ContinuousDistributions.betinc(x, a, b) : 1.0 - BT * ContinuousDistributions.betinc(1.0 - x, b, a);
        return Bcdf;
    }

    public static double fCdf(double x, int f1, int f2) {
        if (x < 0.0 || f1 <= 0 || f2 <= 0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double Z = x / (x + (double)f2 / (double)f1);
        double FCdf = ContinuousDistributions.betaCdf(Z, (double)f1 / 2.0, (double)f2 / 2.0);
        return FCdf;
    }

    private static double gCf(double x, double A) {
        double A0 = 0.0;
        double B0 = 1.0;
        double A1 = 1.0;
        double B1 = x;
        double AOLD = 0.0;
        double N = 0.0;
        while (Math.abs((A1 - AOLD) / A1) > 1.0E-5) {
            AOLD = A1;
            A0 = A1 + ((N += 1.0) - A) * A0;
            B0 = B1 + (N - A) * B0;
            A1 = x * A0 + N * A1;
            B1 = x * B0 + N * B1;
            A0 /= B1;
            B0 /= B1;
            A1 /= B1;
            B1 = 1.0;
        }
        double Prob = Math.exp(A * Math.log(x) - x - ContinuousDistributions.logGamma(A)) * A1;
        return 1.0 - Prob;
    }

    private static double gSer(double x, double A) {
        double T9;
        double G = T9 = 1.0 / A;
        double I = 1.0;
        while (T9 > G * 1.0E-5) {
            T9 = T9 * x / (A + I);
            G += T9;
            I += 1.0;
        }
        return G *= Math.exp(A * Math.log(x) - x - ContinuousDistributions.logGamma(A));
    }

    protected static double gammaCdf(double x, double a) {
        double GI;
        if (x < 0.0) {
            throw new IllegalArgumentException("The x parameter must be positive.");
        }
        if (a > 200.0) {
            double z = (x - a) / Math.sqrt(a);
            double y = ContinuousDistributions.gaussCdf(z);
            double b1 = 2.0 / Math.sqrt(a);
            double phiz = 0.39894228 * Math.exp(-z * z / 2.0);
            double w = y - b1 * (z * z - 1.0) * phiz / 6.0;
            double b2 = 6.0 / a;
            int zXor4 = (int)z ^ 4;
            double u = 3.0 * b2 * (z * z - 3.0) + b1 * b1 * ((double)zXor4 - 10.0 * z * z + 15.0);
            GI = w - phiz * z * u / 72.0;
        } else {
            GI = x < a + 1.0 ? ContinuousDistributions.gSer(x, a) : ContinuousDistributions.gCf(x, a);
        }
        return GI;
    }

    public static double gammaCdf(double x, double a, double b) {
        if (a <= 0.0 || b <= 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double GammaCdf = ContinuousDistributions.gammaCdf(x / b, a);
        return GammaCdf;
    }

    public static double uniformCdf(double x, double a, double b) {
        if (a >= b) {
            throw new IllegalArgumentException("The a must be smaller than b.");
        }
        double probabilitySum = x < a ? 0.0 : (x < b ? (x - a) / (b - a) : 1.0);
        return probabilitySum;
    }

    public static double kolmogorov(double z) {
        if (z < 0.27) {
            return 0.0;
        }
        if (z > 3.2) {
            return 1.1;
        }
        double ks = 0.0;
        double y = -2.0 * z * z;
        for (int i = 27; i >= 1; i -= 2) {
            ks = Math.exp((double)i * y) * (1.0 - ks);
        }
        return 1.0 - 2.0 * ks;
    }

    public static double gaussInverseCdf(double p) {
        double z;
        double P_LOW = 0.02425;
        double P_HIGH = 0.97575;
        double[] ICDF_A = new double[]{-39.69683028665376, 220.9460984245205, -275.9285104469687, 138.357751867269, -30.66479806614716, 2.506628277459239};
        double[] ICDF_B = new double[]{-54.47609879822406, 161.5858368580409, -155.6989798598866, 66.80131188771972, -13.28068155288572};
        double[] ICDF_C = new double[]{-0.007784894002430293, -0.3223964580411365, -2.400758277161838, -2.549732539343734, 4.374664141464968, 2.938163982698783};
        double[] ICDF_D = new double[]{0.007784695709041462, 0.3224671290700398, 2.445134137142996, 3.754408661907416};
        if (p == 0.0) {
            z = Double.NEGATIVE_INFINITY;
        } else if (p == 1.0) {
            z = Double.POSITIVE_INFINITY;
        } else if (Double.isNaN(p) || p < 0.0 || p > 1.0) {
            z = Double.NaN;
        } else if (p < 0.02425) {
            double q = Math.sqrt(-2.0 * Math.log(p));
            z = (((((ICDF_C[0] * q + ICDF_C[1]) * q + ICDF_C[2]) * q + ICDF_C[3]) * q + ICDF_C[4]) * q + ICDF_C[5]) / ((((ICDF_D[0] * q + ICDF_D[1]) * q + ICDF_D[2]) * q + ICDF_D[3]) * q + 1.0);
        } else if (0.97575 < p) {
            double q = Math.sqrt(-2.0 * Math.log(1.0 - p));
            z = -(((((ICDF_C[0] * q + ICDF_C[1]) * q + ICDF_C[2]) * q + ICDF_C[3]) * q + ICDF_C[4]) * q + ICDF_C[5]) / ((((ICDF_D[0] * q + ICDF_D[1]) * q + ICDF_D[2]) * q + ICDF_D[3]) * q + 1.0);
        } else {
            double q = p - 0.5;
            double r = q * q;
            z = (((((ICDF_A[0] * r + ICDF_A[1]) * r + ICDF_A[2]) * r + ICDF_A[3]) * r + ICDF_A[4]) * r + ICDF_A[5]) * q / (((((ICDF_B[0] * r + ICDF_B[1]) * r + ICDF_B[2]) * r + ICDF_B[3]) * r + ICDF_B[4]) * r + 1.0);
        }
        return z;
    }

    public static double chisquareInverseCdf(double p, int df) {
        double CHI_EPSILON = 1.0E-6;
        double CHI_MAX = 99999.0;
        double minchisq = 0.0;
        double maxchisq = 99999.0;
        if (p <= 0.0) {
            return 99999.0;
        }
        if (p >= 1.0) {
            return 0.0;
        }
        double chisqval = (double)df / Math.sqrt(p);
        while (maxchisq - minchisq > 1.0E-6) {
            if (1.0 - ContinuousDistributions.chisquareCdf(chisqval, df) < p) {
                maxchisq = chisqval;
            } else {
                minchisq = chisqval;
            }
            chisqval = (maxchisq + minchisq) * 0.5;
        }
        return chisqval;
    }

    public static double normalQuantile(double p, double mu, double sigma) {
        double val;
        if (sigma < 0.0) {
            throw new IllegalArgumentException("The sigma parameter must be positive.");
        }
        if (sigma == 0.0) {
            return mu;
        }
        double q = p - 0.5;
        if (0.075 <= p && p <= 0.925) {
            double r = 0.180625 - q * q;
            val = q * (((((((r * 2509.0809287301227 + 33430.57558358813) * r + 67265.7709270087) * r + 45921.95393154987) * r + 13731.69376550946) * r + 1971.5909503065513) * r + 133.14166789178438) * r + 3.3871328727963665) / (((((((r * 5226.495278852854 + 28729.085735721943) * r + 39307.89580009271) * r + 21213.794301586597) * r + 5394.196021424751) * r + 687.1870074920579) * r + 42.31333070160091) * r + 1.0);
        } else {
            double r = q > 0.0 ? 1.0 - p : p;
            r = Math.sqrt(-Math.log(r));
            val = r <= 5.0 ? ((((((((r += -1.6) * 7.745450142783414E-4 + 0.022723844989269184) * r + 0.2417807251774506) * r + 1.2704582524523684) * r + 3.6478483247632045) * r + 5.769497221460691) * r + 4.630337846156546) * r + 1.4234371107496835) / (((((((r * 1.0507500716444169E-9 + 5.475938084995345E-4) * r + 0.015198666563616457) * r + 0.14810397642748008) * r + 0.6897673349851) * r + 1.6763848301838038) * r + 2.053191626637759) * r + 1.0) : ((((((((r += -5.0) * 2.0103343992922881E-7 + 2.7115555687434876E-5) * r + 0.0012426609473880784) * r + 0.026532189526576124) * r + 0.29656057182850487) * r + 1.7848265399172913) * r + 5.463784911164114) * r + 6.657904643501103) / (((((((r * 2.0442631033899397E-15 + 1.421511758316446E-7) * r + 1.8463183175100548E-5) * r + 7.868691311456133E-4) * r + 0.014875361290850615) * r + 0.1369298809227358) * r + 0.599832206555888) * r + 1.0);
            if (q < 0.0) {
                val = -val;
            }
        }
        return mu + sigma * val;
    }

    public static double dirichletPdf(double[] pi, double[] ai) {
        double probability = 1.0;
        double sumAi = 0.0;
        double productGammaAi = 1.0;
        int piLength = pi.length;
        for (int i = 0; i < piLength; ++i) {
            double tmp = ai[i];
            sumAi += tmp;
            productGammaAi *= ContinuousDistributions.gamma(tmp);
            probability *= Math.pow(pi[i], tmp - 1.0);
        }
        return probability *= ContinuousDistributions.gamma(sumAi) / productGammaAi;
    }

    public static double dirichletPdf(double[] pi, double a) {
        double probability = 1.0;
        int piLength = pi.length;
        for (int i = 0; i < piLength; ++i) {
            probability *= Math.pow(pi[i], a - 1.0);
        }
        double sumAi = (double)piLength * a;
        double productGammaAi = Math.pow(ContinuousDistributions.gamma(a), piLength);
        return probability *= ContinuousDistributions.gamma(sumAi) / productGammaAi;
    }

    public static double[] multinomialGaussianSample(double[] mean, double[][] covariance) {
        MultivariateNormalDistribution gaussian = new MultivariateNormalDistribution(mean, covariance);
        gaussian.reseedRandomGenerator(RandomGenerator.getThreadLocalRandom().nextLong());
        return gaussian.sample();
    }

    public static double multinomialGaussianPdf(double[] mean, double[][] covariance, double[] x) {
        MultivariateNormalDistribution gaussian = new MultivariateNormalDistribution(mean, covariance);
        return gaussian.density(x);
    }
}

