/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.anova;

import com.datumbox.framework.common.dataobjects.AssociativeArray2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection2D;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Anova {
    public static boolean oneWayTestEqualVars(TransposeDataCollection transposeDataCollection, double aLevel, AssociativeArray2D outputTable) {
        int n = 0;
        int k = transposeDataCollection.size();
        if (k <= 1) {
            throw new IllegalArgumentException("The collection must contain observations from at least 2 groups.");
        }
        HashMap<Object, Integer> nj = new HashMap<Object, Integer>();
        double Ymean = 0.0;
        HashMap<Object, Double> Yjmean = new HashMap<Object, Double>();
        for (Map.Entry<Object, FlatDataCollection> entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = entry.getValue();
            int m = flatDataCollection.size();
            if (m == 0) {
                throw new IllegalArgumentException("The number of observations in each group but be larger than 0.");
            }
            nj.put(j, m);
            n += m;
            double sum = Descriptives.sum(flatDataCollection);
            Yjmean.put(j, sum / (double)m);
            Ymean += sum;
        }
        if (n - k <= 0) {
            throw new IllegalArgumentException("The number of observations must be larger than the number of groups.");
        }
        Ymean /= (double)n;
        double RSS = 0.0;
        double BSS = 0.0;
        for (Map.Entry<Object, FlatDataCollection> entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = entry.getValue();
            Iterator<Double> it = flatDataCollection.iteratorDouble();
            while (it.hasNext()) {
                RSS += Math.pow(it.next() - (Double)Yjmean.get(j), 2.0);
            }
            BSS += (double)((Integer)nj.get(j)).intValue() * Math.pow((Double)Yjmean.get(j) - Ymean, 2.0);
        }
        double F = BSS / (double)(k - 1) / (RSS / (double)(n - k));
        double pvalue = ContinuousDistributions.fCdf(F, k - 1, n - k);
        boolean rejectH0 = false;
        double a = aLevel / 2.0;
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        if (outputTable != null) {
            double TSS = RSS + BSS;
            outputTable.clear();
            outputTable.put2d("BG", "SSq", BSS);
            outputTable.put2d("BG", "DF", k - 1);
            outputTable.put2d("BG", "MSq", BSS / (double)(k - 1));
            outputTable.put2d("BG", "F", F);
            outputTable.put2d("BG", "p", 1.0 - pvalue);
            outputTable.put2d("WG", "SSq", RSS);
            outputTable.put2d("WG", "DF", n - k);
            outputTable.put2d("WG", "MSq", RSS / (double)(n - k));
            outputTable.put2d("R", "SSq", TSS);
            outputTable.put2d("R", "DF", n - 1);
        }
        return rejectH0;
    }

    public static boolean oneWayTestEqualVars(TransposeDataCollection transposeDataCollection, double aLevel) {
        return Anova.oneWayTestEqualVars(transposeDataCollection, aLevel, null);
    }

    public static boolean oneWayTestNotEqualVars(TransposeDataCollection transposeDataCollection, double aLevel, AssociativeArray2D outputTable) {
        int n = 0;
        int k = transposeDataCollection.size();
        if (k <= 1) {
            throw new IllegalArgumentException("The collection must contain observations from at least 2 groups.");
        }
        HashMap<Object, Integer> nj = new HashMap<Object, Integer>();
        double Ymean = 0.0;
        HashMap<Object, Double> Yjmean = new HashMap<Object, Double>();
        HashMap<Object, Double> Yjvariance = new HashMap<Object, Double>();
        for (Map.Entry<Object, FlatDataCollection> entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = entry.getValue();
            int m = flatDataCollection.size();
            if (m == 0) {
                throw new IllegalArgumentException("The number of observations in each group but be larger than 0.");
            }
            nj.put(j, m);
            n += m;
            double sum = Descriptives.sum(flatDataCollection);
            Yjmean.put(j, sum / (double)m);
            Ymean += sum;
            Yjvariance.put(j, Descriptives.variance(flatDataCollection, true));
        }
        if (n - k <= 0) {
            throw new IllegalArgumentException("The number of observations must be larger than the number of groups.");
        }
        Ymean /= (double)n;
        double BSS = 0.0;
        HashMap<Object, Double> mj = new HashMap<Object, Double>();
        double mjSum = 0.0;
        for (Map.Entry<Object, FlatDataCollection> entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            BSS += (double)((Integer)nj.get(j)).intValue() * Math.pow((Double)Yjmean.get(j) - Ymean, 2.0);
            mj.put(j, (1.0 - (double)((Integer)nj.get(j)).intValue() / (double)n) * (Double)Yjvariance.get(j));
            mjSum += ((Double)mj.get(j)).doubleValue();
        }
        double dfDenominator = 0.0;
        for (Map.Entry entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            dfDenominator += Math.pow((Double)mj.get(j) / mjSum, 2.0) / ((double)((Integer)nj.get(j)).intValue() - 1.0);
        }
        int df = (int)Math.round(1.0 / dfDenominator);
        double d = BSS / mjSum;
        double pvalue = ContinuousDistributions.fCdf(d, k - 1, df);
        boolean rejectH0 = false;
        double a = aLevel / 2.0;
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        if (outputTable != null) {
            outputTable.clear();
            outputTable.put2d("BG", "Fparts", BSS);
            outputTable.put2d("BG", "DF", k - 1);
            outputTable.put2d("BG", "F", d);
            outputTable.put2d("BG", "p", 1.0 - pvalue);
            outputTable.put2d("WG", "Fparts", mjSum);
            outputTable.put2d("WG", "DF", df);
        }
        return rejectH0;
    }

    public static boolean oneWayTestNotEqualVars(TransposeDataCollection transposeDataCollection, double aLevel) {
        return Anova.oneWayTestNotEqualVars(transposeDataCollection, aLevel, null);
    }

    public static boolean twoWayTestEqualCellsEqualVars(TransposeDataCollection2D twoFactorDataCollection, double aLevel, AssociativeArray2D outputTable) {
        Object i;
        Integer Itotal = twoFactorDataCollection.size();
        Integer Jtotal = null;
        for (Map.Entry<Object, TransposeDataCollection> entry : twoFactorDataCollection.entrySet()) {
            if (Jtotal != null) {
                if (Jtotal.intValue() == entry.getValue().size()) continue;
                throw new IllegalArgumentException("The cells must be of equal size.");
            }
            Jtotal = entry.getValue().size();
            if (Jtotal != 0) continue;
            throw new IllegalArgumentException("The size of Jtotal must be larger than 0.");
        }
        int n = 0;
        HashMap<Object, Integer> nidotdot = new HashMap<Object, Integer>();
        HashMap<Object, Integer> ndotjdot = new HashMap<Object, Integer>();
        HashMap nijdot = new HashMap();
        double Ydotdotdot = 0.0;
        HashMap<Object, Double> Yidotdot = new HashMap<Object, Double>();
        HashMap<Object, Double> Ydotjdot = new HashMap<Object, Double>();
        HashMap Yijdot = new HashMap();
        for (Map.Entry<Object, TransposeDataCollection> entry : twoFactorDataCollection.entrySet()) {
            Object IfactorAlevel = entry.getKey();
            TransposeDataCollection listOfBlevels = entry.getValue();
            if (!Yidotdot.containsKey(IfactorAlevel)) {
                Yidotdot.put(IfactorAlevel, 0.0);
                nidotdot.put(IfactorAlevel, 0);
                Yijdot.put(IfactorAlevel, new HashMap());
                nijdot.put(IfactorAlevel, new HashMap());
            }
            for (Map.Entry<Object, FlatDataCollection> entry2 : listOfBlevels.entrySet()) {
                Object JfactorBlevel = entry2.getKey();
                FlatDataCollection flatDataCollection = entry2.getValue();
                if (!Ydotjdot.containsKey(JfactorBlevel)) {
                    Ydotjdot.put(JfactorBlevel, 0.0);
                    ndotjdot.put(JfactorBlevel, 0);
                }
                if (!((Map)Yijdot.get(IfactorAlevel)).containsKey(JfactorBlevel)) {
                    ((Map)Yijdot.get(IfactorAlevel)).put(JfactorBlevel, 0.0);
                    ((Map)nijdot.get(IfactorAlevel)).put(JfactorBlevel, 0);
                }
                Iterator<Object> it = flatDataCollection.iteratorDouble();
                while (it.hasNext()) {
                    Double value = (Double)it.next();
                    Ydotdotdot += value.doubleValue();
                    ++n;
                    Yidotdot.put(IfactorAlevel, (Double)Yidotdot.get(IfactorAlevel) + value);
                    nidotdot.put(IfactorAlevel, (Integer)nidotdot.get(IfactorAlevel) + 1);
                    Ydotjdot.put(JfactorBlevel, (Double)Ydotjdot.get(JfactorBlevel) + value);
                    ndotjdot.put(JfactorBlevel, (Integer)ndotjdot.get(JfactorBlevel) + 1);
                    ((Map)Yijdot.get(IfactorAlevel)).put(JfactorBlevel, (Double)((Map)Yijdot.get(IfactorAlevel)).get(JfactorBlevel) + value);
                    ((Map)nijdot.get(IfactorAlevel)).put(JfactorBlevel, (Integer)((Map)nijdot.get(IfactorAlevel)).get(JfactorBlevel) + 1);
                }
            }
        }
        Ydotdotdot /= (double)n;
        for (Map.Entry<Object, TransposeDataCollection> entry : Yidotdot.entrySet()) {
            i = entry.getKey();
            Yidotdot.put(i, (Double)((Object)entry.getValue()) / (double)((Integer)nidotdot.get(i)).intValue());
        }
        for (Map.Entry<Object, TransposeDataCollection> entry : Ydotjdot.entrySet()) {
            Object j = entry.getKey();
            Ydotjdot.put(j, (Double)((Object)entry.getValue()) / (double)((Integer)ndotjdot.get(j)).intValue());
        }
        for (Map.Entry<Object, TransposeDataCollection> entry : Yijdot.entrySet()) {
            i = entry.getKey();
            Map listOfYj = (Map)((Object)entry.getValue());
            for (Map.Entry<Object, FlatDataCollection> entry3 : listOfYj.entrySet()) {
                Object j = entry3.getKey();
                Double value = (Double)((Object)entry3.getValue());
                ((Map)Yijdot.get(i)).put(j, value / (double)((Integer)((Map)nijdot.get(i)).get(j)).intValue());
            }
        }
        double SSA = 0.0;
        double SSB = 0.0;
        double SSAB = 0.0;
        double SST = 0.0;
        for (Map.Entry<Object, TransposeDataCollection> entry1 : twoFactorDataCollection.entrySet()) {
            Object IfactorAlevel = entry1.getKey();
            TransposeDataCollection listOfBlevels = entry1.getValue();
            for (Map.Entry<Object, FlatDataCollection> entry2 : listOfBlevels.entrySet()) {
                Object JfactorBlevel = entry2.getKey();
                FlatDataCollection flatDataCollection = entry2.getValue();
                Iterator<Double> it = flatDataCollection.iteratorDouble();
                while (it.hasNext()) {
                    Double value = it.next();
                    SST += Math.pow(value - Ydotdotdot, 2.0);
                    SSA += Math.pow((Double)Yidotdot.get(IfactorAlevel) - Ydotdotdot, 2.0);
                    SSB += Math.pow((Double)Ydotjdot.get(JfactorBlevel) - Ydotdotdot, 2.0);
                    SSAB += Math.pow((Double)((Map)Yijdot.get(IfactorAlevel)).get(JfactorBlevel) - (Double)Yidotdot.get(IfactorAlevel) - (Double)Ydotjdot.get(JfactorBlevel) + Ydotdotdot, 2.0);
                }
            }
        }
        double SSE = SST - SSA - SSB - SSAB;
        double SSR = SSA + SSB + SSAB;
        int dfA = Itotal - 1;
        double MSA = SSA / (double)dfA;
        int dfB = Jtotal - 1;
        double MSB = SSB / (double)dfB;
        int dfAB = (Itotal - 1) * (Jtotal - 1);
        double MSAB = SSAB / (double)dfAB;
        int dfE = n - Itotal * Jtotal;
        double MSE = SSE / (double)dfE;
        int dfR = dfA + dfB + dfAB;
        double MSR = SSR / (double)dfR;
        double FA = MSA / MSE;
        double Apvalue = ContinuousDistributions.fCdf(FA, dfA, dfE);
        double FB = MSB / MSE;
        double Bpvalue = ContinuousDistributions.fCdf(FB, dfB, dfE);
        double FAB = MSAB / MSE;
        double ABpvalue = ContinuousDistributions.fCdf(FAB, dfAB, dfE);
        double FR = MSR / MSE;
        double Rpvalue = ContinuousDistributions.fCdf(FR, dfR, dfE);
        boolean rejectH0 = false;
        double a = aLevel / 2.0;
        if (Rpvalue <= a || Rpvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        if (outputTable != null) {
            outputTable.clear();
            outputTable.put2d("Model", "SSq", SSR);
            outputTable.put2d("Model", "DF", dfR);
            outputTable.put2d("Model", "MSq", MSR);
            outputTable.put2d("Model", "F", FR);
            outputTable.put2d("Model", "p", 1.0 - Rpvalue);
            outputTable.put2d("AFactor", "SSq", SSA);
            outputTable.put2d("AFactor", "DF", dfA);
            outputTable.put2d("AFactor", "MSq", MSA);
            outputTable.put2d("AFactor", "F", FA);
            outputTable.put2d("AFactor", "p", 1.0 - Apvalue);
            outputTable.put2d("BFactor", "SSq", SSB);
            outputTable.put2d("BFactor", "DF", dfB);
            outputTable.put2d("BFactor", "MSq", MSB);
            outputTable.put2d("BFactor", "F", FB);
            outputTable.put2d("BFactor", "p", 1.0 - Bpvalue);
            outputTable.put2d("A*BFactor", "SSq", SSAB);
            outputTable.put2d("A*BFactor", "DF", dfAB);
            outputTable.put2d("A*BFactor", "MSq", MSAB);
            outputTable.put2d("A*BFactor", "F", FAB);
            outputTable.put2d("A*BFactor", "p", 1.0 - ABpvalue);
            outputTable.put2d("Error", "SSq", SSE);
            outputTable.put2d("Error", "DF", dfE);
            outputTable.put2d("Error", "MSq", MSE);
            outputTable.put2d("Total", "SSq", SST);
            outputTable.put2d("Total", "DF", n - 1);
        }
        return rejectH0;
    }

    public static boolean twoWayTestEqualCellsEqualVars(TransposeDataCollection2D twoFactorDataCollection, double aLevel) {
        return Anova.twoWayTestEqualCellsEqualVars(twoFactorDataCollection, aLevel, null);
    }
}

