/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.mathematics.regularization;

import java.util.Map;

public class L1Regularizer {
    public static <K> void updateWeights(double l1, double learningRate, Map<K, Double> weights, Map<K, Double> newWeights) {
        if (l1 > 0.0) {
            for (Map.Entry<K, Double> e : newWeights.entrySet()) {
                K column = e.getKey();
                double wi_k_intermediate = e.getValue();
                if (wi_k_intermediate > 0.0) {
                    newWeights.put(column, Math.max(0.0, wi_k_intermediate - l1 * wi_k_intermediate));
                    continue;
                }
                if (!(wi_k_intermediate < 0.0)) continue;
                newWeights.put(column, Math.min(0.0, wi_k_intermediate + l1 * wi_k_intermediate));
            }
        }
    }

    public static <K> double estimatePenalty(double l1, Map<K, Double> weights) {
        double penalty = 0.0;
        if (l1 > 0.0) {
            double sumAbsWeights = 0.0;
            for (double w : weights.values()) {
                sumAbsWeights += Math.abs(w);
            }
            penalty = l1 * sumAbsWeights;
        }
        return penalty;
    }
}

