/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.regression;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.concurrency.ForkJoinStream;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.AbstractTrainer;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelers.AbstractRegressor;
import com.datumbox.framework.core.machinelearning.common.interfaces.PredictParallelizable;
import com.datumbox.framework.core.machinelearning.common.interfaces.TrainParallelizable;
import com.datumbox.framework.core.mathematics.regularization.ElasticNetRegularizer;
import com.datumbox.framework.core.mathematics.regularization.L1Regularizer;
import com.datumbox.framework.core.mathematics.regularization.L2Regularizer;
import java.util.Map;

public class NLMS
extends AbstractRegressor<ModelParameters, TrainingParameters>
implements PredictParallelizable,
TrainParallelizable {
    private boolean parallelized = true;
    protected final ForkJoinStream streamExecutor = new ForkJoinStream(this.knowledgeBase.getConfiguration().getConcurrencyConfiguration());

    protected NLMS(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected NLMS(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    public boolean isParallelized() {
        return this.parallelized;
    }

    @Override
    public void setParallelized(boolean parallelized) {
        this.parallelized = parallelized;
    }

    @Override
    protected void _predict(Dataframe newData) {
        this._predictDatasetParallel(newData, this.knowledgeBase.getStorageEngine(), this.knowledgeBase.getConfiguration().getConcurrencyConfiguration());
    }

    @Override
    public PredictParallelizable.Prediction _predictRecord(Record r) {
        Map<Object, Double> thitas = ((ModelParameters)this.knowledgeBase.getModelParameters()).getThitas();
        double yPredicted = this.hypothesisFunction(r.getX(), thitas);
        return new PredictParallelizable.Prediction(yPredicted, null);
    }

    @Override
    protected void _fit(Dataframe trainingData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<Object, Double> thitas = modelParameters.getThitas();
        thitas.put("~CONSTANT", 0.0);
        for (Object feature : trainingData.getXDataTypes().keySet()) {
            thitas.put(feature, 0.0);
        }
        TrainingParameters trainingParameters = (TrainingParameters)this.knowledgeBase.getTrainingParameters();
        double minError = Double.POSITIVE_INFINITY;
        double learningRate = trainingParameters.getLearningRate();
        int totalIterations = trainingParameters.getTotalIterations();
        StorageEngine storageEngine = this.knowledgeBase.getStorageEngine();
        for (int iteration = 0; iteration < totalIterations; ++iteration) {
            this.logger.debug("Iteration {}", (Object)iteration);
            Map<Object, Double> tmp_newThitas = storageEngine.getBigMap("tmp_newThitas", Object.class, Double.class, StorageEngine.MapType.HASHMAP, StorageEngine.StorageHint.IN_MEMORY, false, true);
            tmp_newThitas.putAll(thitas);
            this.batchGradientDescent(trainingData, tmp_newThitas, learningRate);
            double newError = this.calculateError(trainingData, tmp_newThitas);
            if (newError > minError) {
                learningRate /= 2.0;
            } else {
                learningRate *= 1.05;
                minError = newError;
                thitas.clear();
                thitas.putAll(tmp_newThitas);
            }
            storageEngine.dropBigMap("tmp_newThitas", tmp_newThitas);
        }
    }

    private void batchGradientDescent(Dataframe trainingData, Map<Object, Double> newThitas, double learningRate) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        double multiplier = learningRate / (double)trainingData.size();
        Map<Object, Double> thitas = modelParameters.getThitas();
        this.streamExecutor.forEach(StreamMethods.stream(trainingData.stream(), this.isParallelized()), r -> {
            double error = TypeInference.toDouble(r.getY()) - this.hypothesisFunction(r.getX(), thitas);
            double errorMultiplier = multiplier * error;
            Map map = newThitas;
            synchronized (map) {
                for (Map.Entry<Object, Object> entry : r.getX().entrySet()) {
                    Object feature = entry.getKey();
                    Double value = TypeInference.toDouble(entry.getValue());
                    newThitas.put(feature, (Double)newThitas.get(feature) + errorMultiplier * value);
                }
                newThitas.put("~CONSTANT", (Double)newThitas.get("~CONSTANT") + errorMultiplier);
            }
        });
        double l1 = ((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getL1();
        double l2 = ((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getL2();
        if (l1 > 0.0 && l2 > 0.0) {
            ElasticNetRegularizer.updateWeights(l1, l2, learningRate, thitas, newThitas);
        } else if (l1 > 0.0) {
            L1Regularizer.updateWeights(l1, learningRate, thitas, newThitas);
        } else if (l2 > 0.0) {
            L2Regularizer.updateWeights(l2, learningRate, thitas, newThitas);
        }
    }

    private double calculateError(Dataframe trainingData, Map<Object, Double> thitas) {
        double error = this.streamExecutor.sum(StreamMethods.stream(trainingData.stream(), this.isParallelized()).mapToDouble(r -> {
            double yPredicted = this.hypothesisFunction(r.getX(), thitas);
            return Math.pow(TypeInference.toDouble(r.getY()) - yPredicted, 2.0);
        }));
        error /= (double)trainingData.size();
        double l1 = ((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getL1();
        double l2 = ((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getL2();
        if (l1 > 0.0 && l2 > 0.0) {
            error += ElasticNetRegularizer.estimatePenalty(l1, l2, thitas);
        } else if (l1 > 0.0) {
            error += L1Regularizer.estimatePenalty(l1, thitas);
        } else if (l2 > 0.0) {
            error += L2Regularizer.estimatePenalty(l2, thitas);
        }
        return error;
    }

    private double hypothesisFunction(AssociativeArray x, Map<Object, Double> thitas) {
        double sum = thitas.get("~CONSTANT");
        for (Map.Entry<Object, Object> entry : x.entrySet()) {
            Object feature = entry.getKey();
            Double xj = TypeInference.toDouble(entry.getValue());
            sum += thitas.getOrDefault(feature, 0.0) * xj;
        }
        return sum;
    }

    public static class TrainingParameters
    extends AbstractTrainer.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
        private int totalIterations = 1000;
        private double learningRate = 0.1;
        private double l1 = 0.0;
        private double l2 = 0.0;

        public int getTotalIterations() {
            return this.totalIterations;
        }

        public void setTotalIterations(int totalIterations) {
            this.totalIterations = totalIterations;
        }

        public double getLearningRate() {
            return this.learningRate;
        }

        public void setLearningRate(double learningRate) {
            this.learningRate = learningRate;
        }

        public double getL1() {
            return this.l1;
        }

        public void setL1(double l1) {
            this.l1 = l1;
        }

        public double getL2() {
            return this.l2;
        }

        public void setL2(double l2) {
            this.l2 = l2;
        }
    }

    public static class ModelParameters
    extends AbstractTrainer.AbstractModelParameters {
        private static final long serialVersionUID = 1L;
        @BigMap(keyClass=Object.class, valueClass=Double.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=false)
        private Map<Object, Double> thitas;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }

        public Map<Object, Double> getThitas() {
            return this.thitas;
        }

        protected void setThitas(Map<Object, Double> thitas) {
            this.thitas = thitas;
        }
    }
}

