/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.regression;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.DataframeMatrix;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.common.utilities.PHPMethods;
import com.datumbox.framework.core.machinelearning.common.abstracts.AbstractTrainer;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelers.AbstractRegressor;
import com.datumbox.framework.core.machinelearning.common.interfaces.StepwiseCompatible;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.OpenMapRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class MatrixLinearRegression
extends AbstractRegressor<ModelParameters, TrainingParameters>
implements StepwiseCompatible {
    protected MatrixLinearRegression(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected MatrixLinearRegression(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void _predict(Dataframe newData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<Object, Double> thitas = modelParameters.getThitas();
        Map<Object, Integer> featureIds = modelParameters.getFeatureIds();
        int d = thitas.size();
        OpenMapRealVector coefficients = new OpenMapRealVector(d);
        for (Map.Entry<Object, Double> entry : thitas.entrySet()) {
            Integer featureId = featureIds.get(entry.getKey());
            coefficients.setEntry(featureId.intValue(), entry.getValue().doubleValue());
        }
        HashMap<Integer, Integer> recordIdsReference = new HashMap<Integer, Integer>();
        DataframeMatrix matrixDataset = DataframeMatrix.parseDataset(newData, recordIdsReference, featureIds);
        RealMatrix X = matrixDataset.getX();
        RealVector Y = X.operate((RealVector)coefficients);
        for (Map.Entry<Integer, Record> e : newData.entries()) {
            Integer rId = e.getKey();
            Record r = e.getValue();
            int rowId = (Integer)recordIdsReference.get(rId);
            newData._unsafe_set(rId, new Record(r.getX(), r.getY(), Y.getEntry(rowId), r.getYPredictedProbabilities()));
        }
    }

    @Override
    protected void _fit(Dataframe trainingData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        int n = trainingData.size();
        int d = trainingData.xColumnSize();
        Map<Object, Double> thitas = modelParameters.getThitas();
        Map<Object, Integer> featureIds = modelParameters.getFeatureIds();
        DataframeMatrix matrixDataset = DataframeMatrix.newInstance(trainingData, true, null, featureIds);
        RealVector Y = matrixDataset.getY();
        RealMatrix X = matrixDataset.getX();
        RealMatrix Xt = X.transpose();
        LUDecomposition lud = new LUDecomposition(Xt.multiply(X));
        RealMatrix XtXinv = lud.getSolver().getInverse();
        RealVector coefficients = XtXinv.multiply(Xt).operate(Y);
        thitas.put("~CONSTANT", coefficients.getEntry(0));
        for (Map.Entry<Object, Integer> entry : featureIds.entrySet()) {
            Object feature = entry.getKey();
            Integer featureId = entry.getValue();
            thitas.put(feature, coefficients.getEntry(featureId.intValue()));
        }
        double SSE = 0.0;
        for (Object v : (Object)X.operate(coefficients).subtract(Y).toArray()) {
            SSE += v * v;
        }
        double MSE = SSE / (double)(n - (d + 1));
        RealMatrix SE = XtXinv.scalarMultiply(MSE);
        Map<Integer, Object> idsFeatures = PHPMethods.array_flip(featureIds);
        HashMap<Object, Double> pvalues = new HashMap<Object, Double>();
        for (int i = 0; i < d + 1; ++i) {
            double error = SE.getEntry(i, i);
            Object feature = idsFeatures.get(i);
            if (error <= 0.0) {
                pvalues.put(feature, 0.0);
                continue;
            }
            double tstat = coefficients.getEntry(i) / Math.sqrt(error);
            pvalues.put(feature, 1.0 - ContinuousDistributions.studentsCdf(tstat, n - (d + 1)));
        }
        modelParameters.setFeaturePvalues(pvalues);
    }

    @Override
    public Map<Object, Double> getFeaturePvalues() {
        return ((ModelParameters)this.knowledgeBase.getModelParameters()).getFeaturePvalues();
    }

    public static class TrainingParameters
    extends AbstractTrainer.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
    }

    public static class ModelParameters
    extends AbstractTrainer.AbstractModelParameters {
        private static final long serialVersionUID = 1L;
        @BigMap(keyClass=Object.class, valueClass=Double.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=false)
        private Map<Object, Double> thitas;
        @BigMap(keyClass=Object.class, valueClass=Integer.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=false)
        private Map<Object, Integer> featureIds;
        private Map<Object, Double> featurePvalues;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }

        public Map<Object, Double> getThitas() {
            return this.thitas;
        }

        protected void setThitas(Map<Object, Double> thitas) {
            this.thitas = thitas;
        }

        public Map<Object, Integer> getFeatureIds() {
            return this.featureIds;
        }

        protected void setFeatureIds(Map<Object, Integer> featureIds) {
            this.featureIds = featureIds;
        }

        public Map<Object, Double> getFeaturePvalues() {
            return this.featurePvalues;
        }

        protected void setFeaturePvalues(Map<Object, Double> featurePvalues) {
            this.featurePvalues = featurePvalues;
        }
    }
}

