/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.preprocessing;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.AbstractTrainer;
import com.datumbox.framework.core.machinelearning.common.abstracts.transformers.AbstractEncoder;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class CornerConstraintsEncoder
extends AbstractEncoder<ModelParameters, TrainingParameters> {
    protected CornerConstraintsEncoder(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected CornerConstraintsEncoder(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void _fit(Dataframe trainingData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<Object, Object> referenceLevels = modelParameters.getReferenceLevels();
        Set<TypeInference.DataType> supportedXDataTypes = this.getSupportedXDataTypes();
        Map<Object, TypeInference.DataType> xDataTypes = trainingData.getXDataTypes();
        for (Record r : trainingData) {
            for (Map.Entry<Object, Object> entry : r.getX().entrySet()) {
                Object column = entry.getKey();
                Object value = entry.getValue();
                if (value == null || !supportedXDataTypes.contains((Object)xDataTypes.get(column))) continue;
                referenceLevels.putIfAbsent(column, value);
            }
        }
    }

    @Override
    protected void _transform(Dataframe newData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<Object, Object> referenceLevels = modelParameters.getReferenceLevels();
        Map<Object, TypeInference.DataType> columnTypes = newData.getXDataTypes();
        this.streamExecutor.forEach(StreamMethods.stream(newData.entries(), this.isParallelized()), e -> {
            Integer rId = (Integer)e.getKey();
            Record r = (Record)e.getValue();
            AssociativeArray xData = r.getX().copy();
            boolean modified = false;
            for (Object column : r.getX().keySet()) {
                Object referenceLevel = referenceLevels.get(column);
                if (referenceLevel == null) continue;
                Object value = xData.remove(column);
                if (value != null && !referenceLevel.equals(value)) {
                    xData.put(Arrays.asList(column, value), true);
                }
                modified = true;
            }
            if (modified) {
                Record newR = new Record(xData, r.getY(), r.getYPredicted(), r.getYPredictedProbabilities());
                newData._unsafe_set(rId, newR);
            }
        });
        newData.recalculateMeta();
    }

    public static class TrainingParameters
    extends AbstractTrainer.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
    }

    public static class ModelParameters
    extends AbstractTrainer.AbstractModelParameters {
        private static final long serialVersionUID = 1L;
        @BigMap(keyClass=Object.class, valueClass=Object.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=true)
        private Map<Object, Object> referenceLevels;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }

        public Map<Object, Object> getReferenceLevels() {
            return this.referenceLevels;
        }

        protected void setReferenceLevels(Map<Object, Object> referenceLevels) {
            this.referenceLevels = referenceLevels;
        }
    }
}

