/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.modelselection;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.machinelearning.MLBuilder;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelers.AbstractModeler;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelselection.AbstractSplitter;
import com.datumbox.framework.core.machinelearning.common.interfaces.TrainingParameters;
import com.datumbox.framework.core.machinelearning.common.interfaces.ValidationMetrics;
import java.util.Iterator;
import java.util.LinkedList;

public class Validator<VM extends ValidationMetrics> {
    private final Class<VM> vmClass;
    private final Configuration configuration;

    public Validator(Class<VM> vmClass, Configuration configuration) {
        this.vmClass = vmClass;
        this.configuration = configuration;
    }

    public VM validate(Iterator<AbstractSplitter.Split> dataSplits, TrainingParameters trainingParameters) {
        AbstractModeler modeler = (AbstractModeler)MLBuilder.create(trainingParameters, this.configuration);
        LinkedList<VM> validationMetricsList = new LinkedList<VM>();
        while (dataSplits.hasNext()) {
            AbstractSplitter.Split s = dataSplits.next();
            Dataframe trainData = s.getTrain();
            Dataframe testData = s.getTest();
            modeler.fit(trainData);
            trainData.close();
            modeler.predict(testData);
            VM entrySample = ValidationMetrics.newInstance(this.vmClass, testData);
            testData.close();
            validationMetricsList.add(entrySample);
        }
        modeler.close();
        VM avgValidationMetrics = ValidationMetrics.newInstance(this.vmClass, validationMetricsList);
        return avgValidationMetrics;
    }
}

