/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.common.abstracts.modelers;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.AbstractTrainer;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelers.AbstractModeler;
import com.datumbox.framework.core.machinelearning.common.interfaces.Cluster;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractClusterer<CL extends AbstractCluster, MP extends AbstractModelParameters, TP extends AbstractTrainer.AbstractTrainingParameters>
extends AbstractModeler<MP, TP> {
    protected AbstractClusterer(TP trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected AbstractClusterer(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    protected void clearClusters() {
        AbstractModelParameters modelParameters = (AbstractModelParameters)this.knowledgeBase.getModelParameters();
        Map clusterMap = modelParameters.getClusterMap();
        for (Map.Entry e : clusterMap.entrySet()) {
            Integer clusterId = e.getKey();
            AbstractCluster c = (AbstractCluster)e.getValue();
            c.clear();
            clusterMap.put(clusterId, c);
        }
    }

    public Map<Integer, CL> getClusters() {
        return ((AbstractModelParameters)this.knowledgeBase.getModelParameters()).getClusterMap();
    }

    public static abstract class AbstractModelParameters<CL extends AbstractCluster>
    extends AbstractTrainer.AbstractModelParameters {
        private Set<Object> goldStandardClasses = new LinkedHashSet<Object>();
        @BigMap(keyClass=Integer.class, valueClass=AbstractCluster.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_CACHE, concurrent=false)
        private Map<Integer, CL> clusterMap;

        protected AbstractModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }

        public Integer getC() {
            if (this.clusterMap == null) {
                return 0;
            }
            return this.clusterMap.size();
        }

        public Set<Object> getGoldStandardClasses() {
            return this.goldStandardClasses;
        }

        protected void setGoldStandardClasses(Set<Object> goldStandardClasses) {
            this.goldStandardClasses = goldStandardClasses;
        }

        public Map<Integer, CL> getClusterMap() {
            return this.clusterMap;
        }

        protected void setClusterMap(Map<Integer, CL> clusterMap) {
            this.clusterMap = clusterMap;
        }
    }

    public static abstract class AbstractCluster
    implements Cluster {
        protected final Integer clusterId;
        protected int size = 0;

        protected AbstractCluster(Integer clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public int size() {
            return this.size;
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + this.clusterId;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return Objects.equals(this.clusterId, ((AbstractCluster)obj).clusterId);
        }

        protected abstract void clear();

        protected abstract void add(Record var1);

        protected abstract void remove(Record var1);
    }
}

