/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.common.abstracts.featureselectors;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.featureselectors.AbstractScoreBasedFeatureSelector;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCountBasedFeatureSelector<MP extends AbstractScoreBasedFeatureSelector.AbstractModelParameters, TP extends AbstractScoreBasedFeatureSelector.AbstractTrainingParameters>
extends AbstractScoreBasedFeatureSelector<MP, TP> {
    protected AbstractCountBasedFeatureSelector(TP trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected AbstractCountBasedFeatureSelector(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void _fit(Dataframe trainingData) {
        StorageEngine storageEngine = this.knowledgeBase.getStorageEngine();
        AbstractScoreBasedFeatureSelector.AbstractTrainingParameters trainingParameters = (AbstractScoreBasedFeatureSelector.AbstractTrainingParameters)this.knowledgeBase.getTrainingParameters();
        AbstractScoreBasedFeatureSelector.AbstractModelParameters modelParameters = (AbstractScoreBasedFeatureSelector.AbstractModelParameters)this.knowledgeBase.getModelParameters();
        Set<TypeInference.DataType> supportedXDataTypes = this.getSupportedXDataTypes();
        Map<Object, TypeInference.DataType> xDataTypes = trainingData.getXDataTypes();
        HashMap<Object, Integer> tmp_classCounts = new HashMap<Object, Integer>();
        Map<List<Object>, Integer> tmp_featureClassCounts = storageEngine.getBigMap("tmp_featureClassCounts", List.class, Integer.class, StorageEngine.MapType.HASHMAP, StorageEngine.StorageHint.IN_MEMORY, false, true);
        Map<Object, Double> tmp_featureCounts = storageEngine.getBigMap("tmp_featureCounts", Object.class, Double.class, StorageEngine.MapType.HASHMAP, StorageEngine.StorageHint.IN_MEMORY, false, true);
        this.logger.debug("Estimating featureCounts");
        for (Object r : trainingData) {
            for (Map.Entry<Object, Object> entry : ((Record)r).getX().entrySet()) {
                Double value;
                Object column = entry.getKey();
                if (!supportedXDataTypes.contains((Object)xDataTypes.get(column)) || !((value = TypeInference.toDouble(entry.getValue())) > 0.0)) continue;
                double featureCounter = tmp_featureCounts.getOrDefault(column, 0.0);
                tmp_featureCounts.put(column, featureCounter += 1.0);
            }
        }
        Integer rareFeatureThreshold = trainingParameters.getRareFeatureThreshold();
        if (rareFeatureThreshold != null && rareFeatureThreshold > 0) {
            this.removeRareFeatures(tmp_featureCounts, rareFeatureThreshold);
        }
        this.logger.debug("Estimating classCounts and featureClassCounts");
        for (Record r : trainingData) {
            Object theClass = r.getY();
            Integer classCounter = tmp_classCounts.getOrDefault(theClass, 0);
            classCounter = classCounter + 1;
            tmp_classCounts.put(theClass, classCounter);
            for (Map.Entry<Object, Object> entry : r.getX().entrySet()) {
                Double value;
                Object column = entry.getKey();
                if (!supportedXDataTypes.contains((Object)xDataTypes.get(column)) || !((value = TypeInference.toDouble(entry.getValue())) > 0.0)) continue;
                List<Object> featureClassTuple = Arrays.asList(column, theClass);
                Integer featureClassCounter = tmp_featureClassCounts.getOrDefault(featureClassTuple, 0);
                featureClassCounter = featureClassCounter + 1;
                tmp_featureClassCounts.put(featureClassTuple, featureClassCounter);
            }
        }
        Map<Object, Double> featureScores = modelParameters.getFeatureScores();
        this.estimateFeatureScores(featureScores, trainingData.size(), tmp_classCounts, tmp_featureClassCounts, tmp_featureCounts);
        tmp_classCounts.clear();
        storageEngine.dropBigMap("tmp_featureClassCounts", tmp_featureClassCounts);
        storageEngine.dropBigMap("tmp_featureCounts", tmp_featureCounts);
        Integer maxFeatures = trainingParameters.getMaxFeatures();
        if (maxFeatures != null && maxFeatures < featureScores.size()) {
            this.keepTopFeatures(featureScores, maxFeatures);
        }
    }

    @Override
    protected Set<TypeInference.DataType> getSupportedXDataTypes() {
        return new HashSet<TypeInference.DataType>(Arrays.asList(TypeInference.DataType.BOOLEAN, TypeInference.DataType.NUMERICAL));
    }

    @Override
    protected Set<TypeInference.DataType> getSupportedYDataTypes() {
        return new HashSet<TypeInference.DataType>(Arrays.asList(TypeInference.DataType.BOOLEAN, TypeInference.DataType.CATEGORICAL, TypeInference.DataType.ORDINAL));
    }

    protected abstract void estimateFeatureScores(Map<Object, Double> var1, int var2, Map<Object, Integer> var3, Map<List<Object>, Integer> var4, Map<Object, Double> var5);
}

