/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.common.abstracts;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.storage.abstracts.BigMapHolder;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.common.utilities.RandomGenerator;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.machinelearning.common.dataobjects.KnowledgeBase;
import com.datumbox.framework.core.machinelearning.common.interfaces.ModelParameters;
import com.datumbox.framework.core.machinelearning.common.interfaces.Trainable;
import com.datumbox.framework.core.machinelearning.common.interfaces.TrainingParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTrainer<MP extends AbstractModelParameters, TP extends AbstractTrainingParameters>
implements Trainable<MP, TP> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final KnowledgeBase<MP, TP> knowledgeBase;
    private boolean stored;

    protected AbstractTrainer(TP trainingParameters, Configuration configuration) {
        String knowledgeBaseName = this.createKnowledgeBaseName("kb" + RandomGenerator.getThreadLocalRandomUnseeded().nextLong(), configuration.getStorageConfiguration().getStorageNameSeparator());
        this.knowledgeBase = new KnowledgeBase(knowledgeBaseName, configuration, trainingParameters);
        this.stored = false;
    }

    protected AbstractTrainer(String storageName, Configuration configuration) {
        String knowledgeBaseName = this.createKnowledgeBaseName(storageName, configuration.getStorageConfiguration().getStorageNameSeparator());
        this.knowledgeBase = new KnowledgeBase(knowledgeBaseName, configuration);
        this.stored = true;
    }

    @Override
    public MP getModelParameters() {
        return (MP)((AbstractModelParameters)this.knowledgeBase.getModelParameters());
    }

    @Override
    public TP getTrainingParameters() {
        return (TP)((AbstractTrainingParameters)this.knowledgeBase.getTrainingParameters());
    }

    @Override
    public void fit(Dataframe trainingData) {
        this.logger.info("fit()");
        this.knowledgeBase.clear();
        this._fit(trainingData);
    }

    @Override
    public void save(String storageName) {
        this.logger.info("save()");
        String knowledgeBaseName = this.createKnowledgeBaseName(storageName, this.knowledgeBase.getConfiguration().getStorageConfiguration().getStorageNameSeparator());
        this.knowledgeBase.save(knowledgeBaseName);
        this.stored = true;
    }

    @Override
    public void delete() {
        this.logger.info("delete()");
        this.knowledgeBase.delete();
    }

    @Override
    public void close() {
        this.logger.info("close()");
        if (this.stored) {
            this.knowledgeBase.close();
        } else {
            this.knowledgeBase.delete();
        }
    }

    protected abstract void _fit(Dataframe var1);

    protected final String createKnowledgeBaseName(String storageName, String separator) {
        return storageName + separator + this.getClass().getSimpleName();
    }

    public static abstract class AbstractTrainingParameters
    implements TrainingParameters {
    }

    public static abstract class AbstractModelParameters
    extends BigMapHolder
    implements ModelParameters {
        protected AbstractModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }
    }
}

