/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.common.text.extractors;

import com.datumbox.framework.core.common.interfaces.Extractable;
import com.datumbox.framework.core.common.interfaces.Parameterizable;
import com.datumbox.framework.core.common.text.tokenizers.AbstractTokenizer;
import com.datumbox.framework.core.common.text.tokenizers.WhitespaceTokenizer;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public abstract class AbstractTextExtractor<TP extends AbstractParameters, K, V>
implements Extractable<K, V, String> {
    protected final TP parameters;

    public AbstractTextExtractor(TP parameters) {
        this.parameters = parameters;
    }

    protected AbstractTokenizer generateTokenizer() {
        Class<? extends AbstractTokenizer> tokenizer = ((AbstractParameters)this.parameters).getTokenizer();
        if (tokenizer == null) {
            return null;
        }
        try {
            return tokenizer.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public abstract Map<K, V> extract(String var1);

    public static <T extends AbstractTextExtractor, TP extends AbstractParameters> T newInstance(TP parameters) {
        try {
            Class<?> tClass = parameters.getClass().getEnclosingClass();
            return (T)((AbstractTextExtractor)tClass.getConstructor(parameters.getClass()).newInstance(parameters));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static abstract class AbstractParameters
    implements Parameterizable {
        private Class<? extends AbstractTokenizer> tokenizer = WhitespaceTokenizer.class;

        public Class<? extends AbstractTokenizer> getTokenizer() {
            return this.tokenizer;
        }

        public void setTokenizer(Class<? extends AbstractTokenizer> tokenizer) {
            this.tokenizer = tokenizer;
        }
    }
}

