/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.storage.abstracts;

import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.common.utilities.ReflectionMethods;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedList;

public abstract class BigMapHolder
implements Serializable {
    protected BigMapHolder(StorageEngine storageEngine) {
        this.bigMapInitializer(storageEngine);
    }

    private void bigMapInitializer(StorageEngine storageEngine) {
        for (Field field : ReflectionMethods.getAllFields(new LinkedList<Field>(), this.getClass())) {
            if (!field.isAnnotationPresent(BigMap.class)) continue;
            this.initializeBigMapField(storageEngine, field);
        }
    }

    private void initializeBigMapField(StorageEngine storageEngine, Field field) {
        field.setAccessible(true);
        try {
            BigMap a = field.getAnnotation(BigMap.class);
            field.set(this, storageEngine.getBigMap(field.getName(), a.keyClass(), a.valueClass(), a.mapType(), a.storageHint(), a.concurrent(), false));
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }
}

