/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.dataobjects;

import com.datumbox.framework.common.dataobjects.AbstractDataStructureMap;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TypeInference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AssociativeArray
extends AbstractDataStructureMap<Map<Object, Object>> {
    private static final long serialVersionUID = 1L;

    public static AssociativeArray copy2Unmodifiable(AssociativeArray original) {
        LinkedHashMap<Object, Object> internalData = new LinkedHashMap();
        internalData.putAll((Map)original.internalData);
        internalData = Collections.unmodifiableMap(internalData);
        return new AssociativeArray((Map<Object, Object>)internalData);
    }

    public static AssociativeArray convert2Unmodifiable(AssociativeArray original) {
        return new AssociativeArray(Collections.unmodifiableMap((Map)original.internalData));
    }

    public AssociativeArray() {
        super(new LinkedHashMap());
    }

    public AssociativeArray(Map<Object, Object> internalData) {
        super(internalData);
    }

    public AssociativeArray copy() {
        AssociativeArray copy = new AssociativeArray();
        ((Map)copy.internalData).putAll((Map)this.internalData);
        return copy;
    }

    public final void overwrite(Map<Object, Object> data) {
        ((Map)this.internalData).clear();
        ((Map)this.internalData).putAll(data);
    }

    public final void addValues(AssociativeArray array) {
        this.addRemoveValues(array, 1);
    }

    public final void subtractValues(AssociativeArray array) {
        this.addRemoveValues(array, -1);
    }

    private void addRemoveValues(AssociativeArray array, int sign) {
        for (Map.Entry<Object, Object> entry : array.entrySet()) {
            Object column = entry.getKey();
            Double previousValue = TypeInference.toDouble(((Map)this.internalData).get(column));
            if (previousValue == null) {
                previousValue = 0.0;
            }
            ((Map)this.internalData).put(column, previousValue + (double)sign * TypeInference.toDouble(entry.getValue()));
        }
    }

    public final void multiplyValues(double multiplier) {
        for (Map.Entry entry : ((Map)this.internalData).entrySet()) {
            Double previousValue = TypeInference.toDouble(entry.getValue());
            if (previousValue == null) continue;
            ((Map)this.internalData).put(entry.getKey(), previousValue * multiplier);
        }
    }

    public final Object remove(Object key) {
        return ((Map)this.internalData).remove(key);
    }

    public final Object get(Object key) {
        return ((Map)this.internalData).get(key);
    }

    public final Double getDouble(Object key) {
        return TypeInference.toDouble(((Map)this.internalData).get(key));
    }

    public final Object put(Object key, Object value) {
        return ((Map)this.internalData).put(key, value);
    }

    public void putAll(Map<? extends Object, ? extends Object> m) {
        ((Map)this.internalData).putAll(m);
    }

    public final Set<Map.Entry<Object, Object>> entrySet() {
        return ((Map)this.internalData).entrySet();
    }

    public final Set<Object> keySet() {
        return ((Map)this.internalData).keySet();
    }

    public final Collection<Object> values() {
        return ((Map)this.internalData).values();
    }

    public FlatDataCollection toFlatDataCollection() {
        return new FlatDataCollection(((Map)this.internalData).values());
    }

    public FlatDataList toFlatDataList() {
        Collection values = ((Map)this.internalData).values();
        ArrayList<Object> list = values instanceof List ? (ArrayList<Object>)values : new ArrayList<Object>(values);
        return new FlatDataList((List<Object>)list);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssociativeArray)) {
            return false;
        }
        return ((Map)this.internalData).equals(((AssociativeArray)o).internalData);
    }

    public int hashCode() {
        return ((Map)this.internalData).hashCode();
    }

    public String toString() {
        return ((Map)this.internalData).toString();
    }
}

