/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common;

import com.datumbox.framework.common.interfaces.Configurable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableFactory {
    private static final String DEFAULT_POSTFIX = ".default";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurableFactory.class);

    public static <C extends Configurable> C getConfiguration(Class<C> klass) {
        String defaultPropertyFile = "datumbox." + klass.getSimpleName().toLowerCase(Locale.ENGLISH) + DEFAULT_POSTFIX + ".properties";
        Properties properties = new Properties();
        ClassLoader cl = klass.getClassLoader();
        System.out.println("Reading default file=" + defaultPropertyFile);
        try (InputStream in = cl.getResourceAsStream(defaultPropertyFile);){
            properties.load(in);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        String propertyFile = defaultPropertyFile.replaceFirst(DEFAULT_POSTFIX, "");
        if (cl.getResource(propertyFile) != null) {
            try (InputStream in = cl.getResourceAsStream(propertyFile);){
                properties.load(in);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            logger.trace("Loading properties file {}: {}", (Object)propertyFile, (Object)properties);
        } else {
            logger.info("Using default properties file {}: {}", (Object)defaultPropertyFile, (Object)properties);
        }
        return ConfigurableFactory.getConfiguration(klass, properties);
    }

    public static <C extends Configurable> C getConfiguration(Class<C> klass, Properties properties) {
        Configurable configuration;
        try {
            Constructor<C> constructor = klass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            configuration = (Configurable)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        configuration.load(properties);
        return (C)configuration;
    }
}

