/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.applications.nlp;

import com.datumbox.framework.applications.datamodeling.Modeler;
import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.common.text.StringCleaner;
import com.datumbox.framework.core.common.text.extractors.AbstractTextExtractor;
import com.datumbox.framework.core.machinelearning.modelselection.metrics.ClassificationMetrics;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TextClassifier
extends Modeler {
    protected TextClassifier(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
        this.pipeline = Arrays.asList("fs", "ns", "ml");
    }

    protected TextClassifier(String storageName, Configuration configuration) {
        super(storageName, configuration);
        this.pipeline = Arrays.asList("fs", "ns", "ml");
    }

    public void fit(Map<Object, URI> datasets) {
        TrainingParameters tp = (TrainingParameters)this.knowledgeBase.getTrainingParameters();
        Dataframe trainingData = Dataframe.Builder.parseTextFiles(datasets, AbstractTextExtractor.newInstance(tp.getTextExtractorParameters()), this.knowledgeBase.getConfiguration());
        this.fit(trainingData);
        trainingData.close();
    }

    public Dataframe predict(URI datasetURI) {
        HashMap<Object, URI> dataset = new HashMap<Object, URI>();
        dataset.put(null, datasetURI);
        TrainingParameters trainingParameters = (TrainingParameters)this.knowledgeBase.getTrainingParameters();
        Dataframe testDataset = Dataframe.Builder.parseTextFiles(dataset, AbstractTextExtractor.newInstance(trainingParameters.getTextExtractorParameters()), this.knowledgeBase.getConfiguration());
        this.predict(testDataset);
        return testDataset;
    }

    public Record predict(String text) {
        TrainingParameters trainingParameters = (TrainingParameters)this.knowledgeBase.getTrainingParameters();
        Dataframe testDataset = new Dataframe(this.knowledgeBase.getConfiguration());
        testDataset.add(new Record(new AssociativeArray(((AbstractTextExtractor)AbstractTextExtractor.newInstance(trainingParameters.getTextExtractorParameters())).extract(StringCleaner.clear(text))), null));
        this.predict(testDataset);
        Record r = testDataset.iterator().next();
        testDataset.close();
        return r;
    }

    public ClassificationMetrics validate(Dataframe testDataset) {
        this.logger.info("validate()");
        this.predict(testDataset);
        ClassificationMetrics vm = new ClassificationMetrics(testDataset);
        return vm;
    }

    public ClassificationMetrics validate(Map<Object, URI> datasets) {
        TrainingParameters trainingParameters = (TrainingParameters)this.knowledgeBase.getTrainingParameters();
        Dataframe testDataset = Dataframe.Builder.parseTextFiles(datasets, AbstractTextExtractor.newInstance(trainingParameters.getTextExtractorParameters()), this.knowledgeBase.getConfiguration());
        ClassificationMetrics vm = this.validate(testDataset);
        testDataset.close();
        return vm;
    }

    public static class TrainingParameters
    extends Modeler.TrainingParameters {
        private static final long serialVersionUID = 1L;
        private AbstractTextExtractor.AbstractParameters textExtractorParameters;

        public AbstractTextExtractor.AbstractParameters getTextExtractorParameters() {
            return this.textExtractorParameters;
        }

        public void setTextExtractorParameters(AbstractTextExtractor.AbstractParameters textExtractorParameters) {
            this.textExtractorParameters = textExtractorParameters;
        }
    }

    public static class ModelParameters
    extends Modeler.ModelParameters {
        private static final long serialVersionUID = 1L;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }
    }
}

