/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import org.ddogleg.struct.CircularQueue;
import org.junit.Assert;
import org.junit.Test;

public class TestCircularQueue {
    @Test
    public void popHead() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class);
        alg.grow().value = 1;
        alg.grow().value = 2;
        Assert.assertEquals((long)1L, (long)alg.popHead().value);
        Assert.assertEquals((long)1L, (long)alg.size());
        Assert.assertEquals((long)2L, (long)alg.popHead().value);
        Assert.assertEquals((long)0L, (long)alg.size());
    }

    @Test
    public void popTail() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class);
        alg.grow().value = 1;
        alg.grow().value = 2;
        Assert.assertEquals((long)2L, (long)alg.popTail().value);
        Assert.assertEquals((long)1L, (long)alg.size());
        Assert.assertEquals((long)1L, (long)alg.popTail().value);
        Assert.assertEquals((long)0L, (long)alg.size());
    }

    @Test
    public void head() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class);
        alg.grow().value = 1;
        Assert.assertEquals((long)1L, (long)alg.head().value);
        alg.grow().value = 3;
        Assert.assertEquals((long)1L, (long)alg.head().value);
    }

    @Test
    public void head_offset() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class, 3);
        alg.start = 2;
        alg.size = 0;
        alg.grow().value = 1;
        Assert.assertEquals((long)1L, (long)alg.head().value);
        alg.grow().value = 3;
        Assert.assertEquals((long)1L, (long)alg.head().value);
    }

    @Test
    public void tail() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class);
        alg.grow().value = 1;
        Assert.assertEquals((long)1L, (long)alg.tail().value);
        alg.grow().value = 3;
        Assert.assertEquals((long)3L, (long)alg.tail().value);
    }

    @Test
    public void tail_offset() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class);
        alg.start = 2;
        alg.size = 0;
        alg.grow().value = 1;
        Assert.assertEquals((long)1L, (long)alg.tail().value);
        alg.grow().value = 3;
        Assert.assertEquals((long)3L, (long)alg.tail().value);
    }

    @Test
    public void removeHead() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class);
        alg.grow().value = 1;
        alg.grow().value = 2;
        alg.removeHead();
        Assert.assertEquals((long)2L, (long)alg.head().value);
        Assert.assertEquals((long)1L, (long)alg.size());
        alg.removeHead();
        Assert.assertEquals((long)0L, (long)alg.size());
    }

    @Test
    public void removeTail() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class);
        alg.grow().value = 1;
        alg.grow().value = 2;
        alg.removeTail();
        Assert.assertEquals((long)1L, (long)alg.head().value);
        Assert.assertEquals((long)1L, (long)alg.size());
        alg.removeTail();
        Assert.assertEquals((long)0L, (long)alg.size());
    }

    @Test
    public void get() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class, 2);
        Assert.assertEquals((long)2L, (long)((A[])alg.data).length);
        alg.grow().value = 1;
        alg.grow().value = 2;
        Assert.assertEquals((long)1L, (long)alg.get((int)0).value);
        Assert.assertEquals((long)2L, (long)alg.get((int)1).value);
        alg.removeHead();
        alg.grow().value = 3;
        Assert.assertEquals((long)2L, (long)((A[])alg.data).length);
        Assert.assertEquals((long)2L, (long)alg.get((int)0).value);
        Assert.assertEquals((long)3L, (long)alg.get((int)1).value);
    }

    @Test
    public void add() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class, 3);
        Assert.assertEquals((long)3L, (long)((A[])alg.data).length);
        alg.add(new A(1));
        Assert.assertEquals((long)1L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)1L, (long)alg.size);
        alg.add(new A(2));
        Assert.assertEquals((long)1L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)2L, (long)((A[])alg.data)[1].value);
        Assert.assertEquals((long)2L, (long)alg.size);
        alg.add(new A(3));
        alg.add(new A(4));
        Assert.assertEquals((long)1L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)2L, (long)((A[])alg.data)[1].value);
        Assert.assertEquals((long)3L, (long)((A[])alg.data)[2].value);
        Assert.assertEquals((long)4L, (long)((A[])alg.data)[3].value);
        Assert.assertEquals((long)4L, (long)alg.size);
        alg.start = 1;
        alg.data = new A[]{new A(1), new A(2), new A(3)};
        alg.size = 3;
        alg.add(new A(4));
        Assert.assertEquals((long)2L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)3L, (long)((A[])alg.data)[1].value);
        Assert.assertEquals((long)1L, (long)((A[])alg.data)[2].value);
        Assert.assertEquals((long)4L, (long)((A[])alg.data)[3].value);
        Assert.assertEquals((long)4L, (long)alg.size);
        alg.start = 1;
        alg.size = 2;
        alg.data = new A[3];
        alg.add(new A(10));
        Assert.assertEquals((long)10L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)3L, (long)alg.size);
    }

    @Test
    public void addW() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class, 3);
        Assert.assertEquals((long)3L, (long)((A[])alg.data).length);
        alg.addW(new A(1));
        Assert.assertEquals((long)1L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)1L, (long)alg.size);
        alg.addW(new A(2));
        Assert.assertEquals((long)1L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)2L, (long)((A[])alg.data)[1].value);
        Assert.assertEquals((long)2L, (long)alg.size);
        alg.addW(new A(3));
        alg.addW(new A(4));
        Assert.assertEquals((long)4L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)2L, (long)((A[])alg.data)[1].value);
        Assert.assertEquals((long)3L, (long)((A[])alg.data)[2].value);
        Assert.assertEquals((long)3L, (long)alg.size);
        Assert.assertEquals((long)1L, (long)alg.start);
        alg.start = 1;
        alg.size = 2;
        alg.data = new A[3];
        alg.addW(new A(10));
        Assert.assertEquals((long)10L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)3L, (long)alg.size);
    }

    @Test
    public void isEmpty() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class, 3);
        Assert.assertTrue((boolean)alg.isEmpty());
        alg.add(new A(5));
        Assert.assertFalse((boolean)alg.isEmpty());
        alg.removeTail();
        Assert.assertTrue((boolean)alg.isEmpty());
    }

    @Test
    public void reset() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class, 3);
        alg.start = 2;
        alg.size = 5;
        alg.reset();
        Assert.assertEquals((long)0L, (long)alg.size);
        Assert.assertEquals((long)0L, (long)alg.start);
    }

    @Test
    public void grow() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class, 3);
        alg.grow().value = 1;
        Assert.assertEquals((long)1L, (long)alg.size);
        alg.grow().value = 2;
        alg.grow().value = 3;
        alg.grow().value = 4;
        Assert.assertEquals((long)1L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)4L, (long)((A[])alg.data)[3].value);
        Assert.assertEquals((long)4L, (long)alg.size);
        Assert.assertTrue((((A[])alg.data).length >= 4 ? 1 : 0) != 0);
        alg = new CircularQueue<A>(A.class, 3);
        alg.size = 2;
        alg.start = 1;
        alg.grow().value = 1;
        Assert.assertEquals((long)1L, (long)((A[])alg.data)[0].value);
        Assert.assertTrue((null == ((A[])alg.data)[1] ? 1 : 0) != 0);
        Assert.assertTrue((null == ((A[])alg.data)[2] ? 1 : 0) != 0);
    }

    @Test
    public void growW() {
        CircularQueue<A> alg = new CircularQueue<A>(A.class, 3);
        alg.growW().value = 1;
        Assert.assertEquals((long)1L, (long)alg.size);
        alg.growW().value = 2;
        alg.growW().value = 3;
        alg.growW().value = 4;
        Assert.assertEquals((long)4L, (long)((A[])alg.data)[0].value);
        Assert.assertEquals((long)3L, (long)((A[])alg.data)[2].value);
        Assert.assertEquals((long)3L, (long)alg.size);
        Assert.assertTrue((((A[])alg.data).length == 3 ? 1 : 0) != 0);
    }

    public static class A {
        public int value;

        public A() {
        }

        public A(int value) {
            this.value = value;
        }
    }
}

