/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

public class CircularQueue_I32 {
    public int[] data;
    public int start;
    public int size;

    public CircularQueue_I32() {
        this(10);
    }

    public CircularQueue_I32(int dataSize) {
        this.data = new int[dataSize];
    }

    public void reset() {
        this.size = 0;
        this.start = 0;
    }

    public int popHead() {
        int r = this.data[this.start];
        this.removeHead();
        return r;
    }

    public int popTail() {
        int r = this.tail();
        this.removeTail();
        return r;
    }

    public int head() {
        return this.data[this.start];
    }

    public int tail() {
        return this.data[(this.start + this.size - 1) % this.data.length];
    }

    public void removeHead() {
        this.start = (this.start + 1) % this.data.length;
        --this.size;
    }

    public void removeTail() {
        --this.size;
    }

    public int get(int index) {
        return this.data[(this.start + index) % this.data.length];
    }

    public void add(int value) {
        if (this.size >= this.data.length) {
            int[] a = new int[this.nextDataSize()];
            System.arraycopy(this.data, this.start, a, 0, this.data.length - this.start);
            System.arraycopy(this.data, 0, a, this.data.length - this.start, this.start);
            this.start = 0;
            this.data = a;
        }
        this.data[(this.start + this.size) % this.data.length] = value;
        ++this.size;
    }

    public void addW(int value) {
        if (this.size >= this.data.length) {
            this.data[this.start] = value;
            this.start = (this.start + 1) % this.data.length;
        } else {
            this.data[(this.start + this.size) % this.data.length] = value;
            ++this.size;
        }
    }

    private int nextDataSize() {
        if (this.data.length < 1000) {
            return this.data.length * 2;
        }
        if (this.data.length < 10000) {
            return this.data.length * 3 / 2;
        }
        return this.data.length * 6 / 5;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.data.length;
    }
}

