/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Random;
import org.ddogleg.sorting.ApproximateSort_F32;
import org.ddogleg.sorting.SortableParameter_F32;
import org.junit.Assert;
import org.junit.Test;

public class TestApproximateSort_F32 {
    Random rand = new Random(234L);

    @Test
    public void computeRange_primitive() {
        ApproximateSort_F32 alg = new ApproximateSort_F32(12);
        float[] data = this.random(-5.0f, 10.0f, 4, 200);
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 4; i < data.length; ++i) {
            if (data[i] < min) {
                min = data[i];
            }
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        alg.computeRange(data, 4, 200);
        Assert.assertEquals((double)min, (double)alg.minValue, (double)1.0E-8);
        Assert.assertEquals((double)max, (double)alg.maxValue, (double)1.0E-8);
    }

    @Test
    public void computeRange_object() {
        ApproximateSort_F32 alg = new ApproximateSort_F32(12);
        float[] data = this.random(-5.0f, 10.0f, 4, 200);
        SortableParameter_F32[] objs = this.convert(data);
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 4; i < data.length; ++i) {
            if (data[i] < min) {
                min = data[i];
            }
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        alg.computeRange(objs, 4, 200);
        Assert.assertEquals((double)min, (double)alg.minValue, (double)1.0E-8);
        Assert.assertEquals((double)max, (double)alg.maxValue, (double)1.0E-8);
    }

    @Test
    public void sortIndex() {
        int i;
        int numBins = 150;
        float tolerance = 15.0f / (float)numBins;
        float[] data = this.random(-5.0f, 10.0f, 4, 200);
        int[] indexes = new int[200];
        ApproximateSort_F32 alg = new ApproximateSort_F32(-5, 10, numBins);
        alg.sortIndex(data, 4, 200, indexes);
        boolean[] used = new boolean[indexes.length];
        used[indexes[0] - 4] = true;
        for (i = 1; i < indexes.length; ++i) {
            used[indexes[i] - 4] = true;
            Assert.assertTrue((data[indexes[i]] > data[indexes[i - 1]] - tolerance ? 1 : 0) != 0);
        }
        for (i = 0; i < indexes.length; ++i) {
            Assert.assertTrue((boolean)used[i]);
        }
    }

    @Test
    public void sortObject() {
        int numBins = 150;
        float tolerance = 15.0f / (float)numBins;
        float[] data = this.random(-5.0f, 10.0f, 4, 200);
        SortableParameter_F32[] objs = this.convert(data);
        ApproximateSort_F32 alg = new ApproximateSort_F32(-5, 10, numBins);
        alg.sortObject(objs, 4, 200);
        for (int i = 5; i < objs.length; ++i) {
            Assert.assertTrue((objs[i].sortValue > objs[i - 1].sortValue - tolerance ? 1 : 0) != 0);
        }
    }

    public float[] random(float min, float max, int offset, int total) {
        float[] ret = new float[offset + total];
        float range = max - min;
        for (int i = 0; i < total; ++i) {
            ret[i + offset] = this.rand.nextFloat() * range + min;
        }
        return ret;
    }

    public SortableParameter_F32[] convert(float[] data) {
        SortableParameter_F32[] ret = new SortableParameter_F32[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = new SortableParameter_F32(data[i]);
        }
        return ret;
    }
}

