/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.impl.FindRealRootsSturm;
import org.ddogleg.solver.impl.SturmSequence;
import org.junit.Assert;
import org.junit.Test;

public class TestSturmSequence {
    Random rand = new Random(234L);

    @Test
    public void countRealRoots() {
        Polynomial poly = Polynomial.wrap(-1.0, 0.0, 3.0, 1.0);
        Assert.assertEquals((long)1L, (long)this.countRealRoots(poly, -3.0, -2.0));
        Assert.assertEquals((long)0L, (long)this.countRealRoots(poly, 2.0, 3.0));
        Assert.assertEquals((long)3L, (long)this.countRealRoots(poly, -3.0, 3.0));
        Assert.assertEquals((long)3L, (long)this.countRealRoots(poly, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        Assert.assertEquals((long)0L, (long)this.countRealRoots(Polynomial.wrap(2.0), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        Assert.assertEquals((long)1L, (long)this.countRealRoots(Polynomial.wrap(2.0, 3.0), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        Assert.assertEquals((long)0L, (long)this.countRealRoots(Polynomial.wrap(2.0, 3.0), 0.0, Double.POSITIVE_INFINITY));
        Assert.assertEquals((long)0L, (long)this.countRealRoots(Polynomial.wrap(2.0, 3.0), Double.NEGATIVE_INFINITY, -10.0));
        Assert.assertEquals((long)1L, (long)this.countRealRoots(Polynomial.wrap(2.0, 3.0), -2.0, -0.5));
        Assert.assertEquals((long)0L, (long)this.countRealRoots(Polynomial.wrap(2.0, 3.0, 4.0), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        Assert.assertEquals((long)2L, (long)this.countRealRoots(Polynomial.wrap(2.0, -1.0, -4.0), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        poly = Polynomial.wrap(-132.2309, 371.3984, -500.7874, 374.4386, -171.4667, 48.65014, -10.5987, 1.642273, -0.2304341, 0.002112391, -2.273737E-13);
        Assert.assertEquals((long)2L, (long)this.countRealRoots(poly, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    public int countRealRoots(Polynomial p, double low, double high) {
        SturmSequence alg = new SturmSequence(p.size);
        alg.initialize(p);
        return alg.countRealRoots(low, high);
    }

    @Test
    public void checkSequence() {
        Polynomial poly = Polynomial.wrap(-1.0, 0.0, 3.0, 1.0, 5.0, -3.0);
        SturmSequence alg = new SturmSequence(10);
        alg.initialize(poly);
        alg.computeFunctions(-3.0);
        List<Double> expected = this.computeSturm(poly, -3.0);
        Assert.assertEquals((long)expected.size(), (long)alg.sequenceLength);
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((double)expected.get(i), (double)alg.f[i], (double)1.0E-8);
        }
    }

    @Test
    public void checkCount() {
        SturmSequence alg = new SturmSequence(10);
        alg.f = new double[]{0.0, 1.0, 1.0, -1.0, 0.0, -1.0, -1.0, 0.0, 1.0, 1.0};
        alg.sequenceLength = alg.f.length;
        Assert.assertEquals((long)2L, (long)alg.countSignChanges());
        alg.f = new double[]{1.0, 1.0, 1.0, -1.0, 0.0, -1.0, -1.0, 0.0, 1.0, 1.0, 0.0, -1.0, -1.0, 1.0};
        alg.sequenceLength = alg.f.length;
        Assert.assertEquals((long)4L, (long)alg.countSignChanges());
    }

    @Test
    public void checkSequence_Random() {
        for (int i = 3; i < 20; ++i) {
            Polynomial p = new Polynomial(i);
            for (int trial = 0; trial < 20; ++trial) {
                for (int j = 0; j < p.size; ++j) {
                    p.c[j] = (this.rand.nextDouble() - 0.5) * 2.0;
                }
                double value = (this.rand.nextDouble() - 0.5) * 4.0;
                this.compareSequences(p, value);
                this.compareSequences(p, Double.POSITIVE_INFINITY);
                this.compareSequences(p, Double.NEGATIVE_INFINITY);
            }
        }
    }

    @Test
    public void rootCountConsistency_Random() {
        for (int i = 3; i < 20; ++i) {
            Polynomial p = new Polynomial(i);
            for (int trial = 0; trial < 20; ++trial) {
                for (int j = 0; j < p.size; ++j) {
                    p.c[j] = (this.rand.nextDouble() - 0.5) * 2.0;
                }
                SturmSequence alg = new SturmSequence(p.size());
                double low = (this.rand.nextDouble() - 0.5) * 200.0;
                double high = low + this.rand.nextDouble() * 200.0;
                double middle = (low + high) / 2.0;
                alg.initialize(p);
                int every = alg.countRealRoots(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                int all = alg.countRealRoots(low, high);
                int lowN = alg.countRealRoots(low, middle);
                int highN = alg.countRealRoots(middle, high);
                Assert.assertTrue((all >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((lowN >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((highN >= 0 ? 1 : 0) != 0);
                Assert.assertEquals((long)all, (long)(lowN + highN));
                Assert.assertTrue((all <= every ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void checkSpecificPoly01() {
        Polynomial poly = Polynomial.wrap(-41.118263303597175, -120.95384505825373, -417.8477600492497, -634.5308297409192, -347.7885168491812, 6.771313016808563, 79.70258790927392, 31.68212813610444, 5.0248961592587875, 0.2879701466217739, 0.0);
        this.compareSequences(poly, -500.0);
        this.compareSequences(poly, Double.NEGATIVE_INFINITY);
        SturmSequence alg = new SturmSequence(poly.size);
        alg.initialize(poly);
        int N = alg.countRealRoots(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        int M = alg.countRealRoots(-500.0, 500.0);
        Assert.assertTrue((M <= N ? 1 : 0) != 0);
    }

    @Test
    public void checkSpecificPoly02() {
        Polynomial poly = Polynomial.wrap(-0.3497655753671151, 2.9621784756210587, -12.913172341996432, 8.003834540361296, 31.08414734142313, -90.17658402830348, 62.26303231969655, -17.46342135655732, 1.4562328842432635, 0.1227493996590678, -0.0133645583045475);
        FindRealRootsSturm sturm = new FindRealRootsSturm(11, -1.0, 1.0E-10, 20, 20);
        try {
            sturm.process(poly);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void compareSequences(Polynomial p, double value) {
        List<Double> expected = this.computeSturm(p, value);
        SturmSequence alg = new SturmSequence(p.size);
        alg.initialize(p);
        alg.computeFunctions(value);
        Assert.assertEquals((long)expected.size(), (long)alg.sequenceLength);
        for (int j = 0; j < expected.size(); ++j) {
            if (Double.isInfinite(expected.get(j))) {
                Assert.assertTrue((expected.get(j) == alg.f[j] ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((double)expected.get(j), (double)alg.f[j], (double)(Math.abs(alg.f[j]) * 1.0E-6));
        }
    }

    private List<Double> computeSturm(Polynomial poly, double x) {
        Polynomial d = new Polynomial(poly.size);
        PolynomialOps.derivative(poly, d);
        ArrayList<Double> found = new ArrayList<Double>();
        found.add(poly.evaluate(x));
        found.add(d.evaluate(x));
        Polynomial q = new Polynomial(poly.size);
        Polynomial r = new Polynomial(poly.size);
        Polynomial p1 = new Polynomial(poly.size);
        Polynomial p2 = new Polynomial(poly.size);
        p1.setTo(poly);
        p2.setTo(d);
        do {
            PolynomialOps.divide(p1, p2, q, r);
            for (int i = 0; i < r.size; ++i) {
                r.c[i] = -r.c[i];
            }
            found.add(r.evaluate(x));
            p1.setTo(p2);
            p2.setTo(r);
        } while (r.computeDegree() > 0);
        return found;
    }
}

