/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.OptimizationException;
import org.ddogleg.optimization.UnconstrainedMinimization;
import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ddogleg.optimization.functions.GradientLineFunction;
import org.ddogleg.optimization.impl.LineSearchMore94;
import org.ddogleg.optimization.impl.QuasiNewtonBFGS;
import org.ddogleg.optimization.wrap.CachedGradientLineFunction;
import org.ddogleg.optimization.wrap.CachedNumericalGradientLineFunction;

public class QuasiNewtonBFGS_to_UnconstrainedMinimization
implements UnconstrainedMinimization {
    private double line_gtol = 0.9;
    private double line_ftol = 0.001;
    private double line_xtol = 0.1;
    QuasiNewtonBFGS alg;
    LineSearchMore94 lineSearch = new LineSearchMore94();

    @Override
    public void setFunction(FunctionNtoS function, FunctionNtoN gradient, double minFunctionValue) {
        this.lineSearch = new LineSearchMore94();
        GradientLineFunction gradLine = gradient == null ? new CachedNumericalGradientLineFunction(function) : new CachedGradientLineFunction(function, gradient);
        this.alg = new QuasiNewtonBFGS(gradLine, this.lineSearch, minFunctionValue);
    }

    @Override
    public void initialize(double[] initial, double ftol, double gtol) {
        this.lineSearch.setConvergence(this.line_ftol, this.line_gtol, this.line_xtol);
        this.alg.setConvergence(ftol, gtol, this.line_gtol);
        this.alg.initialize(initial);
    }

    @Override
    public double[] getParameters() {
        return this.alg.getParameters();
    }

    @Override
    public boolean iterate() throws OptimizationException {
        return this.alg.iterate();
    }

    @Override
    public boolean isConverged() {
        return this.alg.isConverged();
    }

    @Override
    public String getWarning() {
        return this.alg.getWarning();
    }

    @Override
    public double getFunctionValue() {
        return this.alg.getFx();
    }

    @Override
    public boolean isUpdated() {
        return this.alg.isUpdatedParameters();
    }

    public double getLine_gtol() {
        return this.line_gtol;
    }

    public void setLine_gtol(double line_gtol) {
        this.line_gtol = line_gtol;
    }

    public double getLine_ftol() {
        return this.line_ftol;
    }

    public void setLine_ftol(double line_ftol) {
        this.line_ftol = line_ftol;
    }

    public double getLine_xtol() {
        return this.line_xtol;
    }

    public void setLine_xtol(double line_xtol) {
        this.line_xtol = line_xtol;
    }
}

