/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.functions.FunctionNtoM;

public class TrivialLeastSquaresResidual
implements FunctionNtoM {
    double[] f = new double[3];

    public TrivialLeastSquaresResidual(double a, double b) {
        for (int i = 0; i < 3; ++i) {
            this.f[i] = this.model(a, b, i);
        }
    }

    @Override
    public int getNumOfInputsN() {
        return 2;
    }

    @Override
    public int getNumOfOutputsM() {
        return 3;
    }

    @Override
    public void process(double[] input, double[] output) {
        double a = input[0];
        double b = input[1];
        for (int i = 0; i < 3; ++i) {
            output[i] = this.f[i] - this.model(a, b, i);
        }
    }

    private double model(double a, double b, int func) {
        switch (func) {
            case 0: {
                return a;
            }
            case 1: {
                return b;
            }
        }
        return b * b;
    }
}

