/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.impl.SearchInterpolate;
import org.junit.Assert;
import org.junit.Test;

public class TestSearchInterpolate {
    @Test
    public void quadratic() {
        double a = 2.0;
        double b = -3.0;
        double c = 1.0;
        double alpha0 = 0.67;
        double f0 = this.quad(a, b, c, alpha0);
        double g0 = this.quadDeriv(a, b, alpha0);
        double alpha1 = 3.35;
        double f1 = this.quad(a, b, c, alpha1);
        double expected = -b / (2.0 * a);
        double found = SearchInterpolate.quadratic(f0, g0, alpha0, f1, alpha1);
        Assert.assertEquals((double)expected, (double)found, (double)1.0E-8);
    }

    @Test
    public void quadratic2() {
        double a = 2.0;
        double b = -3.0;
        double c = 1.0;
        double alpha0 = 1.0;
        double g0 = this.quadDeriv(a, b, alpha0);
        double alpha1 = 3.35;
        double g1 = this.quadDeriv(a, b, alpha1);
        double expected = -b / (2.0 * a);
        double found = SearchInterpolate.quadratic2(g0, alpha0, g1, alpha1);
        Assert.assertEquals((double)expected, (double)found, (double)1.0E-8);
    }

    private double quad(double a, double b, double c, double x) {
        return a * x * x + b * x + c;
    }

    private double quadDeriv(double a, double b, double x) {
        return 2.0 * a * x + b;
    }

    @Test
    public void cubic() {
        double a = 2.0;
        double b = -3.0;
        double c = 1.0;
        double d = 3.5;
        double f0 = this.cubic(a, b, c, d, 0.0);
        double g0 = this.cubicDeriv(a, b, c, 0.0);
        double alpha1 = 3.35;
        double f1 = this.cubic(a, b, c, d, alpha1);
        double alpha2 = 1.5;
        double f2 = this.cubic(a, b, c, d, alpha2);
        double expected = (-b + Math.sqrt(b * b - 3.0 * a * c)) / (3.0 * a);
        double found = SearchInterpolate.cubic(f0, g0, f1, alpha1, f2, alpha2);
        Assert.assertEquals((double)expected, (double)found, (double)1.0E-8);
    }

    @Test
    public void cubic2() {
        double a = 2.0;
        double b = -3.0;
        double c = 1.0;
        double d = 3.5;
        double alpha0 = 1.5;
        double f0 = this.cubic(a, b, c, d, alpha0);
        double g0 = this.cubicDeriv(a, b, c, alpha0);
        double alpha1 = 2.0;
        double f1 = this.cubic(a, b, c, d, alpha1);
        double g1 = this.cubicDeriv(a, b, c, alpha1);
        double expected = (-b + Math.sqrt(b * b - 3.0 * a * c)) / (3.0 * a);
        double found = SearchInterpolate.cubic2(f0, g0, alpha0, f1, g1, alpha1);
        Assert.assertEquals((double)expected, (double)found, (double)1.0E-8);
    }

    @Test
    public void cubicSafe_nominal() {
        double a = 2.0;
        double b = -3.0;
        double c = 1.0;
        double d = 3.5;
        double alpha0 = 1.5;
        double f0 = this.cubic(a, b, c, d, alpha0);
        double g0 = this.cubicDeriv(a, b, c, alpha0);
        double alpha1 = 2.0;
        double f1 = this.cubic(a, b, c, d, alpha1);
        double g1 = this.cubicDeriv(a, b, c, alpha1);
        double expected = (-b + Math.sqrt(b * b - 3.0 * a * c)) / (3.0 * a);
        double found = SearchInterpolate.cubicSafe(f0, g0, alpha0, f1, g1, alpha1, 10.0, 100.0);
        Assert.assertEquals((double)expected, (double)found, (double)1.0E-8);
    }

    @Test
    public void cubicSafe_infinity() {
        double a = 2.0;
        double b = 0.0;
        double c = 1.0;
        double d = 3.5;
        double alpha0 = 1.5;
        double f0 = this.cubic(a, b, c, d, alpha0);
        double g0 = this.cubicDeriv(a, b, c, alpha0);
        double alpha1 = 2.0;
        double f1 = this.cubic(a, b, c, d, alpha1);
        double g1 = this.cubicDeriv(a, b, c, alpha1);
        double found = SearchInterpolate.cubicSafe(f0, g0, alpha0, f1, g1, alpha1, 0.1, 100.0);
        Assert.assertEquals((double)0.1, (double)found, (double)1.0E-8);
        found = SearchInterpolate.cubicSafe(f1, g1, alpha1, f0, g0, alpha0, 0.1, 100.0);
        Assert.assertEquals((double)100.0, (double)found, (double)1.0E-8);
    }

    private double cubic(double a, double b, double c, double d, double x) {
        return a * x * x * x + b * x * x + c * x + d;
    }

    private double cubicDeriv(double a, double b, double c, double x) {
        return 3.0 * a * x * x + 2.0 * b * x + c;
    }
}

