/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ddogleg.optimization.impl.NumericalGradientForward;
import org.junit.Assert;
import org.junit.Test;

public class TestNumericalGradientForward {
    @Test
    public void simple() {
        SimpleFunction f = new SimpleFunction();
        NumericalGradientForward alg = new NumericalGradientForward(f);
        double[] output = new double[]{1.0, 1.0, 1.0};
        alg.process(new double[]{2.0, 3.0, 7.0}, output);
        Assert.assertEquals((double)3.0, (double)output[0], (double)1.0E-5);
        Assert.assertEquals((double)-36.0, (double)output[1], (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)output[2], (double)1.0E-5);
    }

    private static class SimpleFunction
    implements FunctionNtoS {
        private SimpleFunction() {
        }

        @Override
        public int getNumOfInputsN() {
            return 3;
        }

        @Override
        public double process(double[] input) {
            double x1 = input[0];
            double x2 = input[1];
            return 3.0 * x1 - 6.0 * x2 * x2;
        }
    }
}

