/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.impl.LevenbergDenseBase;
import org.ejml.alg.dense.linsol.LinearSolverSafe;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;

public class LevenbergMarquardtDampened
extends LevenbergDenseBase {
    protected LinearSolver<DenseMatrix64F> solver;

    public LevenbergMarquardtDampened(LinearSolver<DenseMatrix64F> solver, double initialDampParam) {
        super(initialDampParam);
        this.solver = solver;
        if (solver.modifiesB()) {
            this.solver = new LinearSolverSafe<DenseMatrix64F>(solver);
        }
    }

    @Override
    protected void computeJacobian(DenseMatrix64F residuals, DenseMatrix64F gradient) {
        this.function.computeJacobian(this.jacobianVals.data);
        CommonOps.multInner(this.jacobianVals, this.B);
        CommonOps.multTransA(this.jacobianVals, residuals, gradient);
        CommonOps.extractDiag(this.B, this.Bdiag);
    }

    @Override
    protected boolean computeStep(double lambda, DenseMatrix64F gradientNegative, DenseMatrix64F step) {
        for (int i = 0; i < this.N; ++i) {
            int index = this.B.getIndex(i, i);
            this.B.data[index] = (1.0 + lambda) * this.Bdiag.data[i];
        }
        if (!this.solver.setA(this.B)) {
            return false;
        }
        this.solver.solve(gradientNegative, step);
        return true;
    }

    @Override
    protected double predictedReduction(DenseMatrix64F param, DenseMatrix64F gradientNegative, double mu) {
        double p_dot_g = VectorVectorMult.innerProd(param, gradientNegative);
        double p_JJ_p = 0.0;
        for (int i = 0; i < this.N; ++i) {
            p_JJ_p += param.data[i] * this.Bdiag.data[i] * param.data[i];
        }
        return 0.5 * (p_dot_g + mu * p_JJ_p);
    }
}

