/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.AxisSplitterMedian;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeConstructor;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.ddogleg.nn.alg.KdTreeResult;
import org.ddogleg.nn.alg.KdTreeSearch1;
import org.ddogleg.nn.alg.KdTreeSearch1Standard;
import org.ddogleg.nn.alg.KdTreeSearchN;
import org.ddogleg.nn.alg.KdTreeSearchNStandard;
import org.ddogleg.struct.FastQueue;

public class KdTreeNearestNeighbor<D>
implements NearestNeighbor<D> {
    KdTree tree;
    KdTreeConstructor<D> constructor;
    KdTreeSearch1 search;
    KdTreeSearchN searchN;
    AxisSplitter<D> splitter;
    FastQueue<KdTreeResult> found = new FastQueue<KdTreeResult>(KdTreeResult.class, true);
    KdTreeMemory memory = new KdTreeMemory();

    public KdTreeNearestNeighbor(KdTreeSearch1 search, KdTreeSearchN searchN, AxisSplitter<D> splitter) {
        this.search = search;
        this.searchN = searchN;
        this.splitter = splitter;
    }

    public KdTreeNearestNeighbor() {
        this(new KdTreeSearch1Standard(), new KdTreeSearchNStandard(), new AxisSplitterMedian());
    }

    @Override
    public void init(int N) {
        this.constructor = new KdTreeConstructor<D>(this.memory, N, this.splitter);
    }

    @Override
    public void setPoints(List<double[]> points, List<D> data) {
        if (this.tree != null) {
            this.memory.recycleGraph(this.tree);
        }
        this.tree = this.constructor.construct(points, data);
        this.search.setTree(this.tree);
        this.searchN.setTree(this.tree);
    }

    @Override
    public boolean findNearest(double[] point, double maxDistance, NnData<D> result) {
        if (maxDistance < 0.0) {
            this.search.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.search.setMaxDistance(maxDistance);
        }
        KdTree.Node found = this.search.findNeighbor(point);
        if (found == null) {
            return false;
        }
        result.point = found.point;
        result.data = found.data;
        result.distance = this.search.getDistance();
        return true;
    }

    @Override
    public void findNearest(double[] point, double maxDistance, int numNeighbors, FastQueue<NnData<D>> result) {
        if (maxDistance <= 0.0) {
            this.searchN.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.searchN.setMaxDistance(maxDistance);
        }
        this.found.reset();
        this.searchN.findNeighbor(point, numNeighbors, this.found);
        for (int i = 0; i < this.found.size; ++i) {
            KdTreeResult k = this.found.get(i);
            NnData<D> r = result.grow();
            r.point = k.node.point;
            r.data = k.node.data;
            r.distance = k.distance;
        }
    }
}

