/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.DoubleArrayManager;
import org.ddogleg.fitting.modelset.MeanModelFitter;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.distance.DistanceFromMeanModel;
import org.junit.Assert;
import org.junit.Test;

public abstract class GenericModelMatcherTests {
    protected Random rand = new Random(3486806L);
    protected double minMatchFrac = 1.0;
    protected double parameterTol = 1.0E-8;
    protected boolean checkInlierSet = true;
    private double inlierMean;

    protected void configure(double minMatchFrac, double parameterTol, boolean checkInlierSet) {
        this.minMatchFrac = minMatchFrac;
        this.parameterTol = parameterTol;
        this.checkInlierSet = checkInlierSet;
    }

    @Test
    public void performSimpleModelFit() {
        double mean = 2.5;
        double tol = 0.2;
        ModelMatcher<double[], Double> alg = this.createModel(4, tol * 0.95);
        List<Double> samples = this.createSampleSet(100, mean, tol, 0.1);
        Assert.assertTrue((boolean)alg.process(samples));
        List<Double> matchSet = alg.getMatchSet();
        if (this.checkInlierSet) {
            Assert.assertTrue(((double)matchSet.size() / 90.0 >= this.minMatchFrac ? 1 : 0) != 0);
        }
        Assert.assertEquals((double)this.inlierMean, (double)alg.getModelParameters()[0], (double)this.parameterTol);
    }

    @Test
    public void runMultipleTimes() {
        double mean = 2.5;
        double tol = 0.2;
        ModelMatcher<double[], Double> alg = this.createModel(4, tol);
        for (int i = 0; i < 10; ++i) {
            int N = 200 - i * 10;
            List<Double> samples = this.createSampleSet(N, mean, tol * 0.9, 0.1);
            Assert.assertTrue((boolean)alg.process(samples));
            List<Double> matchSet = alg.getMatchSet();
            double foundMean = alg.getModelParameters()[0];
            if (this.checkInlierSet) {
                Assert.assertTrue(((double)matchSet.size() / ((double)N * 0.9) >= this.minMatchFrac ? 1 : 0) != 0);
            }
            Assert.assertEquals((double)this.inlierMean, (double)foundMean, (double)this.parameterTol);
        }
    }

    private List<Double> createSampleSet(int numPoints, double mean, double modelDist, double fracOutlier) {
        ArrayList<Double> ret = new ArrayList<Double>();
        double numOutlier = (int)((double)numPoints * fracOutlier);
        this.inlierMean = 0.0;
        int i = 0;
        while ((double)i < (double)numPoints - numOutlier) {
            double d = mean + (this.rand.nextDouble() - 0.5) * 2.0 * modelDist;
            this.inlierMean += d;
            ret.add(d);
            ++i;
        }
        this.inlierMean /= (double)ret.size();
        while (ret.size() < numPoints) {
            double d = (this.rand.nextDouble() - 0.5) * 200.0 * modelDist;
            if (!(Math.abs(d) > modelDist * 10.0)) continue;
            ret.add(d);
        }
        Collections.shuffle(ret, this.rand);
        return ret;
    }

    @Test
    public void checkMatchSetToInputIndex() {
        double mean = 2.5;
        double tol = 0.2;
        ModelMatcher<double[], Double> alg = this.createModel(4, tol * 0.95);
        List<Double> samples = this.createSampleSet(100, mean, tol, 0.1);
        Assert.assertTrue((boolean)alg.process(samples));
        List<Double> matchSet = alg.getMatchSet();
        Assert.assertTrue((matchSet.size() > 20 ? 1 : 0) != 0);
        int orderNotTheSame = 0;
        for (int i = 0; i < matchSet.size(); ++i) {
            int expected = samples.indexOf(matchSet.get(i));
            int found = alg.getInputIndex(i);
            if (found != i) {
                ++orderNotTheSame;
            }
            Assert.assertEquals((long)expected, (long)found);
        }
        Assert.assertTrue((orderNotTheSame != matchSet.size() ? 1 : 0) != 0);
    }

    private ModelMatcher<double[], Double> createModel(int minPoints, double fitThreshold) {
        DoubleArrayManager manager = new DoubleArrayManager(1);
        DistanceFromMeanModel dist = new DistanceFromMeanModel();
        MeanModelFitter fitter = new MeanModelFitter();
        return this.createModelMatcher(manager, dist, fitter, fitter, minPoints, fitThreshold);
    }

    public abstract ModelMatcher<double[], Double> createModelMatcher(ModelManager<double[]> var1, DistanceFromModel<double[], Double> var2, ModelGenerator<double[], Double> var3, ModelFitter<double[], Double> var4, int var5, double var6);
}

