/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.example;

import java.util.List;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.PolynomialRoots;
import org.ddogleg.solver.RootFinderType;
import org.ejml.data.Complex64F;

public class ExamplePolynomialRoot {
    public static void main(String[] args) {
        PolynomialRoots finder = PolynomialOps.createRootFinder(6, RootFinderType.EVD);
        Polynomial poly = Polynomial.wrap(2.0, 0.2, 5.0, 3.0);
        if (!finder.process(poly)) {
            throw new RuntimeException("Failed to find solution!");
        }
        List<Complex64F> roots = finder.getRoots();
        System.out.println("Total roots found: " + roots.size());
        for (Complex64F c : roots) {
            if (!c.isReal()) {
                System.out.println("root is imaginary: " + c);
                continue;
            }
            double value = poly.evaluate(c.real);
            System.out.println("Polynomial value at " + c.real + " is " + value);
        }
    }
}

