/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.sizeVertex;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class PjSizeVertex
extends PjProject
implements Runnable {
    protected PgPointSet m_geom = new PgPointSet(2);
    protected int m_numVert;
    protected PdVector m_delSize;
    protected transient Thread m_thread;
    protected PuDouble m_speed;
    protected PuInteger m_discr;
    static /* synthetic */ Class class$vgp$tutor$sizeVertex$PjSizeVertex;

    public PjSizeVertex() {
        super("Size of Vertices Demo");
        this.m_geom.setName("Point Set");
        this.m_geom.setParent((PsUpdateIf)this);
        this.m_delSize = new PdVector();
        this.m_discr = new PuInteger(PsConfig.getMessage((boolean)true, (int)84000, (String)"Discretization"), (PsUpdateIf)this);
        this.m_speed = new PuDouble(PsConfig.getMessage((boolean)true, (int)84000, (String)"Speed"), (PsUpdateIf)this);
        if (this.getClass() == (class$vgp$tutor$sizeVertex$PjSizeVertex == null ? (class$vgp$tutor$sizeVertex$PjSizeVertex = PjSizeVertex.class$("vgp.tutor.sizeVertex.PjSizeVertex")) : class$vgp$tutor$sizeVertex$PjSizeVertex)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_geom.setGlobalVertexSize(10.0);
        this.m_geom.showVertexColors(true);
        this.m_geom.showVertices(true);
        this.m_geom.showVertexSizes(true);
        this.m_discr.setDefBounds(2, 50, 1, 5);
        this.m_discr.setDefValue(10);
        this.m_discr.init();
        this.m_speed.setDefBounds(0.2, 5.0, 0.05, 0.1);
        this.m_speed.setDefValue(1.0);
        this.m_speed.init();
        this.compute();
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        this.m_geom.update((Object)this.m_geom);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.setBackgroundColor(Color.black);
        pvDisplayIf.selectCamera(1);
        pvDisplayIf.showScenegraph(false);
        super.start();
    }

    public void compute() {
        int n;
        int n2 = this.m_discr.getValue();
        this.m_geom.computePlane(n2, n2, -10.0, -10.0, 10.0, 10.0);
        int n3 = this.m_geom.getNumVertices();
        this.m_delSize.setSize(n3);
        for (n = 0; n < n3; ++n) {
            if (Math.random() > 0.5) {
                this.m_delSize.setEntry(n, 1.0);
                continue;
            }
            this.m_delSize.setEntry(n, -1.0);
        }
        for (n = 0; n < n3; ++n) {
            this.m_geom.setVertexSize(n, Math.random());
        }
        this.m_numVert = n3;
        this.computeColorsFromSizeVertex();
    }

    private void computeColorsFromSizeVertex() {
        int n = this.m_geom.getNumVertices();
        this.m_geom.assureVertexColors();
        Color[] colorArray = this.m_geom.getVertexColors();
        for (int i = 0; i < n; ++i) {
            double d = this.m_geom.getVertexSize(i);
            float f = (float)d;
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f), 1.0f, 1.0f));
        }
    }

    public boolean update(Object object) {
        if (object == this) {
            this.m_geom.update((Object)this.m_geom);
        } else {
            if (object == this.m_geom) {
                if (this.m_numVert != this.m_geom.getNumVertices()) {
                    this.compute();
                }
                return true;
            }
            if (object == this.m_discr) {
                this.compute();
                this.m_geom.update((Object)this.m_geom);
                return true;
            }
            if (object == this.m_speed) {
                return true;
            }
        }
        return super.update(object);
    }

    public void changeVertexSize(double d) {
        int n = this.m_geom.getNumVertices();
        if (n != this.m_numVert) {
            return;
        }
        d /= 30.0;
        for (int i = 0; i < n; ++i) {
            double d2 = this.m_geom.getVertexSize(i);
            double d3 = this.m_delSize.getEntry(i) * d;
            if (d3 > 0.0 && d2 + d3 > 1.0 || d3 < 0.0 && d2 + d3 < 0.0) {
                d3 = -d3;
                this.m_delSize.setEntry(i, -this.m_delSize.getEntry(i));
            }
            this.m_geom.setVertexSize(i, d2 + d3);
        }
        this.computeColorsFromSizeVertex();
    }

    public void startAnim() {
        if (this.m_thread != null) {
            return;
        }
        this.m_thread = new Thread((Runnable)this, PsConfig.getProgram() + ": SizeVertex");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public void stopAnim() {
        this.m_thread = null;
    }

    public void run() {
        while (this.m_thread != null) {
            this.changeVertexSize(this.m_speed.getValue());
            this.m_geom.update((Object)this.m_geom);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

