/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgAbcLoader
extends PgAbstractLoader {
    protected int m_indexFirstVertex = 0;

    protected boolean parse(BufferedReader bufferedReader, PgJvxSrc pgJvxSrc) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.ordinaryChars(47, 47);
        streamTokenizer.ordinaryChars(95, 95);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(43);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChars(48, 48);
        streamTokenizer.ordinaryChars(49, 57);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(40, 40);
        streamTokenizer.wordChars(41, 41);
        streamTokenizer.wordChars(126, 126);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(48, 48);
        streamTokenizer.wordChars(49, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(44, 44);
        streamTokenizer.wordChars(59, 59);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.commentChar(35);
        try {
            int n;
            streamTokenizer.nextToken();
            int n2 = Integer.parseInt(streamTokenizer.sval);
            PdVector[] pdVectorArray = new PdVector[n2];
            for (n = 0; n < n2; ++n) {
                pdVectorArray[n] = new PdVector(3);
                for (int i = 0; i < 3; ++i) {
                    streamTokenizer.nextToken();
                    double d = PuDouble.parseDouble((String)streamTokenizer.sval);
                    pdVectorArray[n].setEntry(i, d);
                }
            }
            n = 0;
            PiVector[] piVectorArray = null;
            streamTokenizer.nextToken();
            if (streamTokenizer.sval != null) {
                n = Integer.parseInt(streamTokenizer.sval);
                piVectorArray = new PiVector[n];
                int n3 = 200;
                int[] nArray = new int[n3];
                streamTokenizer.eolIsSignificant(true);
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                for (int i = 0; i < n; ++i) {
                    int n4 = 0;
                    boolean bl = false;
                    block9: while (!bl) {
                        switch (streamTokenizer.nextToken()) {
                            default: {
                                PsDebug.warning((String)("parsing broke abnormally in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype));
                                return false;
                            }
                            case 10: {
                                bl = true;
                                continue block9;
                            }
                            case -2: 
                        }
                        nArray[n4++] = (int)streamTokenizer.nval - this.m_indexFirstVertex;
                    }
                    piVectorArray[i] = new PiVector(n4);
                    piVectorArray[i].set(nArray, n4);
                }
            }
            if (n2 > 0) {
                pgJvxSrc.setNumVertices(n2);
                pgJvxSrc.setVertices(pdVectorArray);
                pgJvxSrc.setDimOfVertices(pdVectorArray[0].getSize());
            }
            if (n > 0) {
                pgJvxSrc.setNumElements(n);
                pgJvxSrc.setElements(piVectorArray);
                int n5 = piVectorArray[0].getSize();
                for (int i = 1; i < n; ++i) {
                    if (piVectorArray[i].getSize() == n5) continue;
                    n5 = -1;
                    break;
                }
                pgJvxSrc.setDimOfElements(n5);
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown = " + iOException.toString() + "\n\tparsing broke abnormally in line=" + streamTokenizer.lineno() + ",\n\treading st.sval=" + streamTokenizer.sval + ",\n\tst.ttype=" + streamTokenizer.ttype));
            return false;
        }
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("# by " + PsConfig.getAuthors() + "\n");
        writer.write("#     File Format = ABC (tutorial demonstration)\n");
        writer.write("#     Geometry    = " + pgJvxSrc.getName() + "\n");
        writer.write("#     Date        = " + new Date().toString() + "\n#\n");
        int n = pgJvxSrc.getNumVertices();
        writer.write("#     Number of Vertices    = " + n + "\n");
        int n2 = pgJvxSrc.getNumElements();
        writer.write("#     Number of Elements\t   = " + n2 + "\n");
        writer.write("#     Index of First Vertex = " + this.m_indexFirstVertex + "\n");
        writer.write("#\n# End of Header\n");
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        writer.write(String.valueOf(n) + "\n");
        for (int i = 0; i < n; ++i) {
            writer.write(PuString.toString((double[])pdVectorArray[i].m_data) + "\n");
        }
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        writer.write(String.valueOf(n2) + "\n");
        for (int i = 0; i < n2; ++i) {
            int n3 = piVectorArray[i].m_data.length;
            if (n3 == 0) {
                PsDebug.warning((String)("Missing vertex references in element[" + i + "]"));
                return false;
            }
            String string = String.valueOf(piVectorArray[i].m_data[0] + this.m_indexFirstVertex);
            for (int j = 1; j < n3; ++j) {
                string = string + " " + String.valueOf(piVectorArray[i].m_data[j] + this.m_indexFirstVertex);
            }
            writer.write(string + "\n");
        }
        return true;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        if (!this.parse(bufferedReader, pgJvxSrc)) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        if (pgJvxSrc.getNumElements() == 0) {
            pgJvxSrc.setType(30);
            pgJvxSrc.showVertices(true);
            pgJvxSrc.setGlobalVertexSize(1.0);
        } else {
            pgJvxSrc.setType(33);
            pgJvxSrc.assureNeighbours();
            pgJvxSrc.showEdges(true);
            pgJvxSrc.showElements(true);
        }
        this.m_geomArr = new PgJvxSrc[]{pgJvxSrc};
        return this.m_geomArr;
    }

    public int getFirstVertexIndex() {
        return this.m_indexFirstVertex;
    }

    public void setFirstVertexIndex(int n) {
        this.m_indexFirstVertex = n;
    }
}

