/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.gui;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.object.PsStackLayout;
import jvx.gui.PuProgressBar;

public class PaProgressTimer
extends Applet
implements ActionListener,
Runnable {
    protected PuProgressBar m_progressBar;
    protected double m_progressValue;
    protected Button m_bStart;
    protected Button m_bAbort;
    protected boolean m_bRunning;
    protected Thread m_thread;
    protected boolean m_bSuspended;

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\nAuthor: Konrad Polthier\r\nVersion: 1.00\r\nApplet shows usage of progress bar\r\n";
    }

    public void init() {
        this.m_progressBar = new PuProgressBar(true);
        this.m_progressBar.setText("Demo Timer");
        this.m_progressValue = 0.0;
        this.setLayout((LayoutManager)new PsStackLayout(2));
        Label label = new Label("Demo of Progress Timer");
        label.setFont(PsConfig.getFont((int)4));
        this.add(label);
        Panel panel = new Panel(new FlowLayout());
        this.m_bStart = new Button("Start");
        this.m_bStart.addActionListener(this);
        panel.add(this.m_bStart);
        this.m_bAbort = new Button("Abort");
        this.m_bAbort.addActionListener(this);
        this.m_bAbort.setEnabled(false);
        panel.add(this.m_bAbort);
        this.add(panel);
        this.add((Component)this.m_progressBar.getInfoPanel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bStart) {
            String string = this.m_bStart.getLabel();
            if (string.equals("Start")) {
                this.m_progressBar.reset();
                this.m_progressValue = 0.0;
                this.m_bRunning = true;
                this.m_bSuspended = false;
                this.m_thread = new Thread((Runnable)this, "JavaView Applet");
                this.m_thread.start();
                this.m_bStart.setLabel("Pause");
            } else if (string.equals("Cont.")) {
                this.m_bRunning = true;
                this.m_progressBar.resumeTimer();
                this.m_bSuspended = false;
                Thread thread = this.m_thread;
                synchronized (thread) {
                    this.m_thread.notify();
                }
                this.m_bStart.setLabel("Pause");
            } else if (string.equals("Pause")) {
                this.m_bRunning = false;
                this.m_progressBar.suspendTimer();
                this.m_bSuspended = true;
                this.m_bStart.setLabel("Cont.");
            }
            this.m_bAbort.setEnabled(true);
        } else if (object == this.m_bAbort) {
            this.m_bRunning = false;
            this.m_bSuspended = false;
            this.m_progressBar.abortTimer();
            this.m_bStart.setLabel("Start");
            this.m_bAbort.setEnabled(false);
        } else {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.m_bRunning && this.m_progressValue < 1.0) {
            this.m_progressValue += 0.01;
            this.m_progressBar.setProgress(this.m_progressValue);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.m_bSuspended) continue;
            Thread thread = this.m_thread;
            synchronized (thread) {
                while (this.m_bSuspended) {
                    try {
                        this.wait(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.m_bRunning = false;
        this.m_bStart.setLabel("Start");
        this.m_bAbort.setEnabled(false);
    }

    public static void main(String[] stringArray) {
        PaProgressTimer paProgressTimer = new PaProgressTimer();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paProgressTimer, stringArray);
        paProgressTimer.init();
        psMainFrame.setOuterBounds(420, 5, 300, 300);
        psMainFrame.setVisible(true);
    }
}

