/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.function.PuFunction;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_Enneper
extends PgSurfaceDescr {
    private int m_defExp = 2;
    protected PuInteger m_exp;
    static /* synthetic */ Class class$vgp$surface$common$PgSurface_Enneper;

    public PgSurface_Enneper() {
        this.setName("Enneper Surface");
        this.m_exp = new PuInteger("Symmetry", (PsUpdateIf)this);
        this.m_function = new PuFunction(2, 3);
        this.m_function.setName("Coordinate Functions");
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_Enneper == null ? (class$vgp$surface$common$PgSurface_Enneper = PgSurface_Enneper.class$("vgp.surface.common.PgSurface_Enneper")) : class$vgp$surface$common$PgSurface_Enneper)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setSize(0.0, -Math.PI, 1.2, Math.PI);
        this.setDiscrBounds(2, 2, 50, 250);
        this.setDiscr(17, 33);
        this.m_exp.setDefBounds(2, 10, 1, 1);
        this.m_exp.setDefValue(this.m_defExp);
        this.m_exp.init();
        this.addParameter((PsObject)this.m_exp);
        this.m_function.setExpression(0, "u*cos(v)-u^(2.*s-1.)/(2.*s-1.)*cos((2.*s-1.)*v)");
        this.m_function.setExpression(1, "-u*sin(v)-u^(2.*s-1.)/(2.*s-1.)*sin((2.*s-1.)*v)");
        this.m_function.setExpression(2, "2./s*u^s*cos(s*v)");
        this.m_function.addParameter("s", (double)this.m_exp.getValue());
        this.setFunction(this.m_function);
        this.useFunctionExpression(false);
    }

    public boolean isUPeriodic() {
        return this.getUMax() - this.getUMin() >= Math.PI * 2;
    }

    public boolean update(Object object) {
        if (object == this.m_exp) {
            this.m_function.setParameter("s", (double)this.m_exp.getValue());
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        double d3 = (double)this.m_exp.getValue() - 1.0;
        pdVector.set(d * Math.cos(d2) - Math.pow(d, 2.0 * d3 + 1.0) / (2.0 * d3 + 1.0) * Math.cos((2.0 * d3 + 1.0) * d2), -d * Math.sin(d2) - Math.pow(d, 2.0 * d3 + 1.0) / (2.0 * d3 + 1.0) * Math.sin((2.0 * d3 + 1.0) * d2), 2.0 / (d3 + 1.0) * Math.pow(d, d3 + 1.0) * Math.cos((d3 + 1.0) * d2));
        return true;
    }

    protected PdVector calc_df_dU(double d, double d2) {
        double d3 = (double)this.m_exp.getValue() - 1.0;
        PdVector pdVector = new PdVector(3);
        pdVector.set(Math.cos(d2) - Math.pow(d, 2.0 * d3) * Math.cos((2.0 * d3 + 1.0) * d2), -Math.sin(d2) - Math.pow(d, 2.0 * d3) * Math.sin((2.0 * d3 + 1.0) * d2), 2.0 * Math.pow(d, d3) * Math.cos((d3 + 1.0) * d2));
        return pdVector;
    }

    protected PdVector calc_df_dV(double d, double d2) {
        double d3 = (double)this.m_exp.getValue() - 1.0;
        PdVector pdVector = new PdVector(3);
        pdVector.set(-d * Math.sin(d2) + Math.pow(d, 2.0 * d3 + 1.0) * Math.sin((2.0 * d3 + 1.0) * d2), -d * Math.cos(d2) - Math.pow(d, 2.0 * d3 + 1.0) * Math.cos((2.0 * d3 + 1.0) * d2), -2.0 * Math.pow(d, d3 + 1.0) * Math.sin((d3 + 1.0) * d2));
        return pdVector;
    }

    protected PdVector calc_ddf_dUdU(double d, double d2) {
        double d3 = (double)this.m_exp.getValue() - 1.0;
        PdVector pdVector = new PdVector(3);
        pdVector.set(-2.0 * d3 * Math.pow(d, 2.0 * d3 - 1.0) * Math.cos((2.0 * d3 + 1.0) * d2), -2.0 * d3 * Math.pow(d, 2.0 * d3 - 1.0) * Math.sin((2.0 * d3 + 1.0) * d2), 2.0 * d3 * Math.pow(d, d3 - 1.0) * Math.cos((d3 + 1.0) * d2));
        return pdVector;
    }

    protected PdVector calc_ddf_dVdV(double d, double d2) {
        double d3 = (double)this.m_exp.getValue() - 1.0;
        PdVector pdVector = new PdVector(3);
        pdVector.set(-d * Math.cos(d2) + (2.0 * d3 + 1.0) * Math.pow(d, 2.0 * d3 + 1.0) * Math.cos((2.0 * d3 + 1.0) * d2), d * Math.sin(d2) + (2.0 * d3 + 1.0) * Math.pow(d, 2.0 * d3 + 1.0) * Math.sin((2.0 * d3 + 1.0) * d2), -2.0 * (d3 + 1.0) * Math.pow(d, d3 + 1.0) * Math.cos((d3 + 1.0) * d2));
        return pdVector;
    }

    protected PdVector calc_ddf_dUdV(double d, double d2) {
        double d3 = (double)this.m_exp.getValue() - 1.0;
        PdVector pdVector = new PdVector(3);
        pdVector.set(-Math.sin(d2) + (2.0 * d3 + 1.0) * Math.pow(d, 2.0 * d3) * Math.sin((2.0 * d3 + 1.0) * d2), -Math.cos(d2) - (2.0 * d3 + 1.0) * Math.pow(d, 2.0 * d3) * Math.cos((2.0 * d3 + 1.0) * d2), -2.0 * (d3 + 1.0) * Math.pow(d, d3) * Math.sin((d3 + 1.0) * d2));
        return pdVector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

