/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_DupinCycloid
extends PgSurfaceDescr {
    private double m_defInnerRadius = 2.0;
    private double m_defTubeRadius = 1.0;
    private double m_defRadius = 1.0;
    private double m_defX = 0.6;
    private double m_defY = 0.0;
    private double m_defZ = 0.5;
    protected PuDouble m_innerRadius;
    protected PuDouble m_tubeRadius;
    protected PuDouble m_radius;
    protected PuDouble m_x;
    protected PuDouble m_y;
    protected PuDouble m_z;
    static /* synthetic */ Class class$vgp$surface$common$PgSurface_DupinCycloid;

    public PgSurface_DupinCycloid() {
        this.setName("DupinCycloid");
        this.m_innerRadius = new PuDouble("Inner Radius", (PsUpdateIf)this);
        this.m_tubeRadius = new PuDouble("Tube Radius", (PsUpdateIf)this);
        this.m_radius = new PuDouble("Sphere Radius", (PsUpdateIf)this);
        this.m_x = new PuDouble("Center (x)", (PsUpdateIf)this);
        this.m_y = new PuDouble("Center (y)", (PsUpdateIf)this);
        this.m_z = new PuDouble("Center (z)", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_DupinCycloid == null ? (class$vgp$surface$common$PgSurface_DupinCycloid = PgSurface_DupinCycloid.class$("vgp.surface.common.PgSurface_DupinCycloid")) : class$vgp$surface$common$PgSurface_DupinCycloid)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setSize(0.0, 0.0, Math.PI * 2, Math.PI * 2);
        this.setDiscr(33, 33);
        this.m_innerRadius.setDefBounds(0.0, 20.0, 0.1, 1.0);
        this.m_innerRadius.setDefValue(this.m_defInnerRadius);
        this.m_innerRadius.init();
        this.addParameter((PsObject)this.m_innerRadius);
        this.m_tubeRadius.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_tubeRadius.setDefValue(this.m_defTubeRadius);
        this.m_tubeRadius.init();
        this.addParameter((PsObject)this.m_tubeRadius);
        this.m_radius.setDefBounds(0.0, 20.0, 0.1, 1.0);
        this.m_radius.setDefValue(this.m_defRadius);
        this.m_radius.init();
        this.addParameter((PsObject)this.m_radius);
        this.m_x.setDefBounds(-10.0, 10.0, 0.1, 1.0);
        this.m_x.setDefValue(this.m_defX);
        this.m_x.init();
        this.addParameter((PsObject)this.m_x);
        this.m_y.setDefBounds(-10.0, 10.0, 0.1, 1.0);
        this.m_y.setDefValue(this.m_defY);
        this.m_y.init();
        this.addParameter((PsObject)this.m_y);
        this.m_z.setDefBounds(-10.0, 10.0, 0.1, 1.0);
        this.m_z.setDefValue(this.m_defZ);
        this.m_z.init();
        this.addParameter((PsObject)this.m_z);
    }

    public boolean isUPeriodic() {
        return this.getUMax() - this.getUMin() >= Math.PI * 2;
    }

    public boolean isVPeriodic() {
        return this.getVMax() - this.getVMin() >= Math.PI * 2;
    }

    public boolean update(Object object) {
        if (object == this.m_innerRadius) {
            return super.update(null);
        }
        if (object == this.m_tubeRadius) {
            return super.update(null);
        }
        if (object == this.m_radius) {
            return super.update(null);
        }
        if (object == this.m_x) {
            return super.update(null);
        }
        if (object == this.m_y) {
            return super.update(null);
        }
        if (object == this.m_z) {
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        double d3 = this.m_tubeRadius.getValue();
        double d4 = this.m_innerRadius.getValue();
        double d5 = this.m_radius.getValue();
        pdVector.set(Math.cos(d) * (d3 * Math.cos(d2) + d4), Math.sin(d) * (d3 * Math.cos(d2) + d4), d3 * Math.sin(d2));
        PdVector pdVector2 = new PdVector(3);
        pdVector2.set(this.m_x.getValue(), this.m_y.getValue(), this.m_z.getValue());
        double d6 = PdVector.sqrDist((PdVector)pdVector, (PdVector)pdVector2);
        pdVector.sub(pdVector2);
        pdVector.multScalar(d5 * d5 / d6);
        pdVector.add(pdVector2);
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

