/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.function.PuFunction;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_Dini
extends PgSurfaceDescr {
    private double m_defTwist = 0.1;
    protected PuDouble m_twist;
    static /* synthetic */ Class class$vgp$surface$common$PgSurface_Dini;

    public PgSurface_Dini() {
        this.setName("Dini");
        this.m_function = new PuFunction(2, 3);
        this.m_function.setName("Coordinate Functions");
        this.m_twist = new PuDouble("Twist", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_Dini == null ? (class$vgp$surface$common$PgSurface_Dini = PgSurface_Dini.class$("vgp.surface.common.PgSurface_Dini")) : class$vgp$surface$common$PgSurface_Dini)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setMaxSize(0.0, -2.5, Math.PI * 10, 2.5);
        this.setSize(0.0, -2.0, 22.462387473167023, 2.0);
        this.setDiscr(150, 33);
        this.m_twist.setDefBounds(0.0, 0.3, 0.01, 0.02);
        this.m_twist.setDefValue(this.m_defTwist);
        this.m_twist.init();
        this.addParameter((PsObject)this.m_twist);
        this.m_function.setExpression(0, "exp(-abs(v))*cos(u)");
        this.m_function.setExpression(1, "exp(-abs(v))*sin(u)");
        this.m_function.setExpression(2, "-sign(v)*(sqrt(1.-exp(-2.*abs(v)))-log((1.+sqrt(1.-exp(-2.*abs(v))))/exp(-abs(v))) + t*u)");
        this.m_function.addParameter("t", this.m_twist.getValue());
        this.setFunction(this.m_function);
        this.useFunctionExpression(false);
    }

    public boolean isUPeriodic() {
        return this.getUMax() - this.getUMin() >= Math.PI * 2;
    }

    public boolean update(Object object) {
        if (object == this.m_twist) {
            this.m_function.setParameter("t", this.m_twist.getValue());
            return super.update(null);
        }
        if (object == this.m_numVLines && this.getNumVLines() < 5) {
            this.m_numVLines.setValue(5);
        }
        return super.update(object);
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        double d3;
        double d4;
        double d5 = this.getVMin();
        if (d5 > (d4 = this.getVMax())) {
            d4 += d5;
            d5 = d4 - d5;
            d4 -= d5;
        }
        double d6 = d2;
        if (d5 < 0.0 && d4 > 0.0) {
            int n = this.getNumVLines() - 1;
            double d7 = (d4 - d5) / (double)n;
            int n2 = (int)Math.round(-d5 / d7);
            if (n2 == 0) {
                ++n2;
            }
            if (n2 == n) {
                --n2;
            }
            d6 = d2 <= (d3 = d5 + d7 * (double)n2) ? d5 / (d3 - d5) * (d3 - d2) : d4 / (d4 - d3) * (d2 - d3);
        }
        double d8 = this.m_twist.getValue();
        double d9 = Math.exp(-Math.abs(d6));
        d3 = Math.sqrt(1.0 - d9 * d9);
        pdVector.set(d9 * Math.cos(d), d9 * Math.sin(d), (double)(-PuMath.sign((double)d6)) * (d3 - Math.log((1.0 + d3) / d9)) + d8 * d);
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

