/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_ScherkDoubly
extends PgWeierstrassDescr {
    private final int m_defaultSymmetry = 2;
    private final double m_defaultRadius = 0.98;
    protected PuInteger m_iSymmetry;
    protected PuDouble m_dRadius;
    private int m_symmetry = 2;
    private double m_radius = 0.98;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_ScherkDoubly;

    public PgWeierstrass_ScherkDoubly() {
        super(1);
        this.setName("Scherk doubly periodic");
        this.m_dRadius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_iSymmetry = new PuInteger("Symmetry", (PsUpdateIf)this);
        this.m_bMarkBnd = true;
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_ScherkDoubly == null ? (class$vgp$minimal$weier$PgWeierstrass_ScherkDoubly = PgWeierstrass_ScherkDoubly.class$("vgp.minimal.weier.PgWeierstrass_ScherkDoubly")) : class$vgp$minimal$weier$PgWeierstrass_ScherkDoubly)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 5);
        this.m_numLines[0].setDefValue(7);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 65, 1, 5);
        this.m_numLines[1].setDefValue(7);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_dRadius.setDefBounds(0.8, 0.999, 0.001, 0.01);
        this.m_dRadius.setDefValue(0.98);
        this.m_dRadius.init();
        this.addParameter((PsObject)this.m_dRadius);
        this.m_iSymmetry.setDefBounds(2, 10, 1, 2);
        this.m_iSymmetry.setDefValue(2);
        this.m_iSymmetry.init();
        this.addParameter((PsObject)this.m_iSymmetry);
        this.setDomain(0, 0.0, 0.98, 0.0, 1.5707963267948966);
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius) {
            this.m_radius = this.m_dRadius.getValue();
            this.setUMax(0, this.m_radius);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_iSymmetry) {
            this.m_symmetry = this.m_iSymmetry.getValue();
            this.m_numUserReflections = 0;
            this.m_userReflections = null;
            this.m_markedBndNr = -1;
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public PuComplex transform(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.polarToRect((double)(1.0 - puComplex.re), (double)(-puComplex.im));
        PuComplex puComplex3 = PuComplex.moebius((PuComplex)PuComplex.ONE, (PuComplex)PuComplex.NEG_ONE, (PuComplex)PuComplex.ONE, (PuComplex)PuComplex.ONE, (PuComplex)puComplex2);
        PuComplex puComplex4 = PuComplex.polarToRect((double)Math.pow(puComplex3.abs(), 1.0 / (double)this.m_symmetry), (double)(puComplex3.arg() / (double)this.m_symmetry - 1.5707963267948966 / (double)this.m_symmetry));
        return puComplex4;
    }

    public PuComplex f(PuComplex puComplex) {
        if (puComplex.abs() < 1.0E-10) {
            return PuComplex.I;
        }
        PuComplex puComplex2 = PuComplex.pow((PuComplex)puComplex, (int)(2 * this.m_symmetry));
        PuComplex puComplex3 = PuComplex.inv((PuComplex)PuComplex.add((PuComplex)puComplex2, (PuComplex)PuComplex.ONE));
        return PuComplex.rotJ((PuComplex)puComplex3);
    }

    public PuComplex g(PuComplex puComplex) {
        if (puComplex.abs() < 1.0E-10) {
            return PuComplex.ZERO;
        }
        return PuComplex.pow((PuComplex)puComplex, (double)((double)this.m_symmetry - 1.0));
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(4 * this.m_symmetry - 1, 0, 0, 0);
        }
    }

    public void getReflections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.reflectPart(1, 0, 3);
            for (int i = 1; i < 2 * this.m_symmetry; ++i) {
                this.reflectPart(2 * i, 2 * i - 1, 0);
                this.reflectPart(2 * i + 1, 2 * i, 3);
            }
        }
        if (piVector == null) {
            this.returnUserReflections();
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        piVector2.m_data[0] = 0;
        piVector2.m_data[2] = 1;
        piVector2.m_data[3] = 1;
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return piVector != null;
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0;
    }

    public int getNumParts(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            return 4 * this.m_symmetry;
        }
        return this.m_numUserReflections + 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

