/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_CatEnn2Twist
extends PgWeierstrassDescr {
    private final double m_defaultRadiusTop = 2.5;
    private final double m_defaultRadiusBottom = 3.2;
    private final double m_defaultAngle = 0.7853981633974483;
    private final double m_defaultNeckSize = 4.5;
    protected PuDouble m_dRadiusTop;
    protected PuDouble m_dRadiusBottom;
    protected PuDouble m_dAngle;
    protected PuDouble m_dNeckSize;
    private double m_radiusTop = 2.5;
    private double m_radiusBottom = 3.2;
    private double m_angle = 0.7853981633974483;
    private double m_neckSize = 4.5;
    private double m_phi;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_CatEnn2Twist;

    public PgWeierstrass_CatEnn2Twist() {
        super(1);
        this.setName("Catenoid - Enneper");
        this.m_dRadiusTop = new PuDouble("Radius Top", (PsUpdateIf)this);
        this.m_dRadiusBottom = new PuDouble("Radius Bottom", (PsUpdateIf)this);
        this.m_dAngle = new PuDouble("Angle", (PsUpdateIf)this);
        this.m_dNeckSize = new PuDouble("Necksize", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_CatEnn2Twist == null ? (class$vgp$minimal$weier$PgWeierstrass_CatEnn2Twist = PgWeierstrass_CatEnn2Twist.class$("vgp.minimal.weier.PgWeierstrass_CatEnn2Twist")) : class$vgp$minimal$weier$PgWeierstrass_CatEnn2Twist)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 10);
        this.m_numLines[0].setDefValue(33);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(7, 300, 1, 10);
        this.m_numLines[1].setDefValue(33);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_dRadiusTop.setDefBounds(0.5, 5.0, 0.1, 1.0);
        this.m_dRadiusTop.setDefValue(2.5);
        this.m_dRadiusTop.init();
        this.addParameter((PsObject)this.m_dRadiusTop);
        this.m_dRadiusBottom.setDefBounds(0.5, 5.0, 0.1, 1.0);
        this.m_dRadiusBottom.setDefValue(3.2);
        this.m_dRadiusBottom.init();
        this.addParameter((PsObject)this.m_dRadiusBottom);
        this.m_dAngle.setDefBounds(-0.7853981633974483, 0.7853981633974483, 0.09817477042468103, 0.39269908169872414);
        this.m_dAngle.setDefValue(0.7853981633974483);
        this.m_dAngle.init();
        this.addParameter((PsObject)this.m_dAngle);
        this.m_dNeckSize.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_dNeckSize.setDefValue(4.5);
        this.m_dNeckSize.init();
        this.addParameter((PsObject)this.m_dNeckSize);
        this.setDomain(0, -3.2, 2.5, 0.0, Math.PI * 2);
        this.computePhi();
    }

    public boolean update(Object object) {
        if (object == this.m_dRadiusTop) {
            this.m_radiusTop = this.m_dRadiusTop.getValue();
            this.setUMax(0, this.m_radiusTop);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dRadiusBottom) {
            this.m_radiusBottom = this.m_dRadiusBottom.getValue();
            this.setUMin(0, -this.m_radiusBottom);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dAngle) {
            this.m_angle = this.m_dAngle.getValue();
            this.computePhi();
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dNeckSize) {
            this.m_neckSize = this.m_dNeckSize.getValue();
            this.computePhi();
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public PuComplex transform(PuComplex puComplex) {
        return PuComplex.polarToRect((double)Math.exp(puComplex.re), (double)puComplex.im);
    }

    public PuComplex f(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.polarToRect((double)this.m_neckSize, (double)this.m_angle);
        PuComplex puComplex3 = PuComplex.sub((PuComplex)PuComplex.sqr((PuComplex)PuComplex.add((PuComplex)puComplex, (PuComplex)PuComplex.inv((PuComplex)puComplex))), (double)2.0);
        PuComplex puComplex4 = PuComplex.sqr((PuComplex)puComplex2);
        PuComplex puComplex5 = PuComplex.mult((PuComplex)puComplex, (PuComplex)puComplex2);
        puComplex3 = PuComplex.sub((PuComplex)PuComplex.sub((PuComplex)puComplex3, (PuComplex)puComplex4), (PuComplex)PuComplex.inv((PuComplex)puComplex4));
        puComplex3 = PuComplex.mult((PuComplex)puComplex3, (PuComplex)PuComplex.sub((PuComplex)puComplex5, (PuComplex)PuComplex.inv((PuComplex)puComplex5)));
        puComplex3 = PuComplex.div((PuComplex)puComplex3, (PuComplex)PuComplex.sub((PuComplex)PuComplex.div((PuComplex)PuComplex.sqr((PuComplex)puComplex), (PuComplex)puComplex2), (PuComplex)puComplex2));
        return PuComplex.div((PuComplex)PuComplex.mult((PuComplex)puComplex3, (PuComplex)PuComplex.polarToRect((double)1.0, (double)this.m_phi)), (PuComplex)puComplex);
    }

    public PuComplex g(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.mult((PuComplex)PuComplex.polarToRect((double)1.0, (double)this.m_angle), (double)this.m_neckSize);
        PuComplex puComplex3 = PuComplex.sub((PuComplex)PuComplex.mult((PuComplex)puComplex, (PuComplex)PuComplex.inv((PuComplex)puComplex2)), (PuComplex)PuComplex.mult((PuComplex)puComplex2, (PuComplex)PuComplex.inv((PuComplex)puComplex)));
        PuComplex puComplex4 = PuComplex.mult((PuComplex)puComplex, (PuComplex)puComplex2);
        PuComplex puComplex5 = PuComplex.div((PuComplex)puComplex3, (PuComplex)PuComplex.sub((PuComplex)puComplex4, (PuComplex)PuComplex.inv((PuComplex)puComplex4)));
        return puComplex5.mult(puComplex);
    }

    private void computePhi() {
        this.m_phi = 0.0;
        if (this.m_neckSize == -1.0) {
            this.m_phi = 0.0;
        } else if (Math.abs(this.m_angle - 0.7853981633974483) < 1.0E-10) {
            this.m_phi = -1.5707963267948966;
        } else if (Math.abs(this.m_angle + 0.7853981633974483) < 1.0E-10) {
            this.m_phi = 1.5707963267948966;
        } else {
            double d = this.m_neckSize * this.m_neckSize * this.m_neckSize;
            this.m_phi = Math.atan(Math.tan(2.0 * this.m_angle) * (1.0 - d) / (1.0 + d));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

