/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.helicoid;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.vecmath.PuMath;

public class PgHelicoid
extends PgElementSet {
    protected boolean m_bAlternate;
    protected boolean m_bFixedHeight;
    protected boolean m_bFixedWidth;
    protected boolean m_bSymmetric;
    protected double m_width;
    protected double m_height;
    private double m_heightFac;
    protected PuDouble m_lineDel = new PuDouble("Line Delta", (PsUpdateIf)this);
    protected PuDouble m_xOffset = new PuDouble("Line Offset", (PsUpdateIf)this);
    protected PuDouble m_axisDel = new PuDouble("Axis Delta", (PsUpdateIf)this);
    protected PuDouble m_torsion = new PuDouble("Torsion", (PsUpdateIf)this);
    protected PuInteger m_numAxisTicks = new PuInteger("Axis Discr", (PsUpdateIf)this);
    protected PuInteger m_numLineTicks = new PuInteger("Line Discr", (PsUpdateIf)this);
    private double m_defLineDelta = 1.0;
    private double m_defXOffset = 0.0;
    private double m_defAxisDelta = 1.0;
    private double m_defTorsion = 1.0;
    private int m_defK = 5;
    private int m_defN = 5;
    static /* synthetic */ Class class$vgp$minimal$helicoid$PgHelicoid;

    public PgHelicoid() {
        super(3);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$helicoid$PgHelicoid == null ? (class$vgp$minimal$helicoid$PgHelicoid = PgHelicoid.class$("vgp.minimal.helicoid.PgHelicoid")) : class$vgp$minimal$helicoid$PgHelicoid)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setDimOfElements(3);
        this.m_bFixedHeight = true;
        this.m_bFixedWidth = true;
        this.m_bSymmetric = true;
        this.m_bAlternate = true;
        this.m_lineDel.setDefBounds(0.001, 4.5, 0.01, 0.1);
        this.m_lineDel.setDefValue(this.m_defLineDelta);
        this.m_lineDel.init();
        this.m_xOffset.setDefBounds(-10.0, 10.0, 0.01, 0.1);
        this.m_xOffset.setDefValue(this.m_defXOffset);
        this.m_xOffset.init();
        this.m_xOffset.setEnabled(!this.m_bSymmetric);
        this.m_axisDel.setDefBounds(0.001, 4.5, 0.01, 0.1);
        this.m_axisDel.setDefValue(this.m_defAxisDelta);
        this.m_axisDel.init();
        this.m_torsion.setDefBounds(0.001, 5.0, 0.01, 0.1);
        this.m_torsion.setDefValue(this.m_defTorsion);
        this.m_torsion.init();
        this.m_heightFac = this.m_axisDel.getValue() / Math.sin(this.m_torsion.getValue());
        this.m_numAxisTicks.setDefBounds(3, 30, 1, 1);
        this.m_numAxisTicks.setDefValue(this.m_defK);
        this.m_numAxisTicks.init();
        this.m_numLineTicks.setDefBounds(2, 30, 1, 1);
        this.m_numLineTicks.setDefValue(this.m_defN);
        this.m_numLineTicks.init();
        this.updateWidth();
        this.updateHeight();
        this.computeSurface();
    }

    public Object clone() {
        PgHelicoid pgHelicoid = (PgHelicoid)((Object)super.clone());
        if (pgHelicoid == null) {
            return null;
        }
        pgHelicoid.m_lineDel = (PuDouble)this.m_lineDel.clone();
        pgHelicoid.m_lineDel.setParent((PsUpdateIf)pgHelicoid);
        pgHelicoid.m_xOffset = (PuDouble)this.m_xOffset.clone();
        pgHelicoid.m_xOffset.setParent((PsUpdateIf)pgHelicoid);
        pgHelicoid.m_axisDel = (PuDouble)this.m_axisDel.clone();
        pgHelicoid.m_axisDel.setParent((PsUpdateIf)pgHelicoid);
        pgHelicoid.m_torsion = (PuDouble)this.m_torsion.clone();
        pgHelicoid.m_torsion.setParent((PsUpdateIf)pgHelicoid);
        pgHelicoid.m_numAxisTicks = (PuInteger)this.m_numAxisTicks.clone();
        pgHelicoid.m_numAxisTicks.setParent((PsUpdateIf)pgHelicoid);
        pgHelicoid.m_numLineTicks = (PuInteger)this.m_numLineTicks.clone();
        pgHelicoid.m_numLineTicks.setParent((PsUpdateIf)pgHelicoid);
        return pgHelicoid;
    }

    public double getLineDelta() {
        return this.m_lineDel.getValue();
    }

    public void setLineDelta(double d) {
        this.m_lineDel.setValue(d);
    }

    public double getAxisDelta() {
        return this.m_axisDel.getValue();
    }

    public void setAxisDelta(double d) {
        this.m_axisDel.setValue(d);
    }

    public double getTorsion() {
        return this.m_torsion.getValue();
    }

    public void setTorsion(double d) {
        this.m_torsion.setValue(d);
    }

    public int getAxisDiscr() {
        return this.m_numAxisTicks.getValue();
    }

    public void setAxisDiscr(int n) {
        this.m_numAxisTicks.setValue(n);
        if (this.m_bFixedHeight) {
            this.m_axisDel.setValue(this.m_height / ((double)n - 1.0));
            this.m_torsion.setValue(Math.asin(this.m_axisDel.getValue() / this.m_heightFac));
        } else {
            this.updateHeight();
        }
    }

    protected void updateHeight() {
        this.m_height = this.m_axisDel.getValue() * (double)(this.m_numAxisTicks.getValue() - 1);
    }

    public int getLineDiscr() {
        return this.m_numLineTicks.getValue();
    }

    public void setLineDiscr(int n) {
        this.m_numLineTicks.setValue(n);
        if (this.m_bFixedWidth) {
            this.m_lineDel.setValue(this.m_width / ((double)n - 1.0));
        } else {
            this.updateWidth();
        }
    }

    protected void updateWidth() {
        this.m_width = this.m_lineDel.getValue() * (double)(this.m_numLineTicks.getValue() - 1);
        if (this.m_bSymmetric) {
            this.m_xOffset.setValue(-this.m_width / 2.0);
        }
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_lineDel) {
            this.updateWidth();
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_xOffset) {
            this.updateWidth();
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_torsion) {
            this.m_heightFac = this.m_axisDel.getValue() / Math.sin(this.m_torsion.getValue());
            this.updateHeight();
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_numAxisTicks) {
            this.setAxisDiscr(this.m_numAxisTicks.getValue());
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_numLineTicks) {
            this.setLineDiscr(this.m_numLineTicks.getValue());
            this.computeSurface();
            return super.update(null);
        }
        if (this.getInspector("Config") == object) {
            this.computeSurface();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void computeSurface(int n, int n2) {
        this.setLineDiscr(n);
        this.setAxisDiscr(n2);
        this.computeSurface();
    }

    protected void computeSurface() {
        int n;
        double d;
        int n2;
        double d2 = this.m_lineDel.getValue();
        int n3 = this.m_numAxisTicks.getValue();
        int n4 = this.m_numLineTicks.getValue();
        this.setNumVertices(n3 * n4);
        double d3 = this.m_torsion.getValue();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            d = d3 * (double)n2;
            dArray[n2] = Math.cos(d);
            dArray2[n2] = Math.sin(d);
        }
        double d4 = Math.PI / (double)n3;
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            d = d3 * (double)n2 + d4;
            dArray3[n2] = Math.cos(d);
            dArray4[n2] = Math.sin(d);
        }
        double[] dArray5 = new double[n4];
        double d5 = this.m_xOffset.getValue();
        double d6 = Math.sin(d3);
        double d7 = 1.0;
        double d8 = this.m_axisDel.getValue();
        for (n = 0; n < n4; ++n) {
            dArray5[n] = d7 * PuMath.sinh((double)(d5 + (double)n * d2)) * d8 / d6;
        }
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                ((PgPointSet)this).m_vertex[n5].m_data[0] = dArray[n2] * dArray5[n];
                ((PgPointSet)this).m_vertex[n5].m_data[1] = dArray2[n2] * dArray5[n];
                ((PgPointSet)this).m_vertex[n5].m_data[2] = (double)n2 * d8;
                ++n5;
            }
        }
        if (!this.m_bAlternate) {
            this.makeQuadrConn(n3, n4);
        } else {
            this.makeAlternatingQuadrConn(n3, n4, true, true);
        }
        this.makeQuadrBnd(n3, n4);
        this.fixBoundaries();
        this.makeElementNormals();
        this.makeVertexNormals();
    }

    public void makeAlternatingQuadrConn(int n, int n2, boolean bl, boolean bl2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        this.setDimOfElements(3);
        this.setNumElements(2 * (n - 1) * (n2 - 1));
        int n3 = 0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n2 - 1; ++j) {
                if (!bl && bl2) {
                    if (j % 2 == 0) {
                        this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, i * n2 + j + 1);
                        this.m_element[n3++].set(i * n2 + j + 1, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
                        continue;
                    }
                    this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j + 1, i * n2 + j + 1);
                    this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
                    continue;
                }
                if (bl && !bl2) {
                    if (i % 2 == 0) {
                        this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, i * n2 + j + 1);
                        this.m_element[n3++].set(i * n2 + j + 1, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
                        continue;
                    }
                    this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j + 1, i * n2 + j + 1);
                    this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
                    continue;
                }
                if (!bl || !bl2) continue;
                if (i % 2 == 0 && j % 2 != 0 || i % 2 != 0 && j % 2 == 0) {
                    this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, i * n2 + j + 1);
                    this.m_element[n3++].set(i * n2 + j + 1, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
                    continue;
                }
                this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j + 1, i * n2 + j + 1);
                this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
            }
        }
        this.makeNeighbour();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

