/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tests;

import cc.mallet.fst.SimpleTagger;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.PipeUtils;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.SimpleTaggerSentence2TokenSequence;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestPipeUtils
extends TestCase {
    private static String data = "f1 f2 CL1\nf1 f3 CL2";

    public TestPipeUtils(String name) {
        super(name);
    }

    public void testPipesAreStupid() {
        StupidPipe p1 = new StupidPipe();
        SimpleTaggerSentence2TokenSequence p2 = new SimpleTaggerSentence2TokenSequence();
        p2.instanceFrom(new Instance(data, null, null, null));
        SerialPipes serial = new SerialPipes(new Pipe[]{p1, p2});
        try {
            serial.getDataAlphabet();
            TestPipeUtils.assertTrue((String)"Test failed: Should have generated exception.", (boolean)false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testConcatenatePipes() {
        StupidPipe p1 = new StupidPipe();
        SimpleTagger.SimpleTaggerSentence2FeatureVectorSequence p2 = new SimpleTagger.SimpleTaggerSentence2FeatureVectorSequence();
        p2.instanceFrom(new Instance(data, null, null, null));
        TestPipeUtils.assertEquals((int)3, (int)p2.getDataAlphabet().size());
        Pipe serial = PipeUtils.concatenatePipes(p1, p2);
        Alphabet dict = serial.getDataAlphabet();
        TestPipeUtils.assertEquals((int)3, (int)dict.size());
        TestPipeUtils.assertTrue((dict == p2.getDataAlphabet() ? 1 : 0) != 0);
    }

    public void testConcatenateNullPipes() {
        StupidPipe p1 = new StupidPipe();
        SimpleTagger.SimpleTaggerSentence2FeatureVectorSequence p2 = new SimpleTagger.SimpleTaggerSentence2FeatureVectorSequence();
        Pipe serial = PipeUtils.concatenatePipes(p1, p2);
        p2.instanceFrom(new Instance(data, null, null, null));
        TestPipeUtils.assertEquals((int)3, (int)serial.getDataAlphabet().size());
    }

    public void testConcatenateBadPipes() {
        SimpleTaggerSentence2TokenSequence p2;
        Alphabet dict2;
        SimpleTaggerSentence2TokenSequence p1 = new SimpleTaggerSentence2TokenSequence();
        Alphabet dict1 = p1.getDataAlphabet();
        TestPipeUtils.assertTrue((dict1 != (dict2 = (p2 = new SimpleTaggerSentence2TokenSequence()).getDataAlphabet()) ? 1 : 0) != 0);
        try {
            PipeUtils.concatenatePipes(p1, p2);
            TestPipeUtils.assertTrue((String)"Test failed: concatenatePipes() allowed putting together incompatible alphabets.", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static Test suite() {
        return new TestSuite(TestPipeUtils.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestPipeUtils(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestPipeUtils.suite();
        }
        TestRunner.run((Test)theSuite);
    }

    private static class StupidPipe
    extends Pipe {
        private StupidPipe() {
        }

        @Override
        public Instance pipe(Instance carrier) {
            System.out.println("StupidPipe says hi.");
            return carrier;
        }
    }
}

