/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.ExecutableChange;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;

public class DefaultGraphModel
extends UndoableEditSupport
implements Serializable,
GraphModel {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected transient Iterator emptyIterator = new EmptyIterator();
    protected List roots = null;
    protected boolean asksAllowsChildren = false;
    protected boolean removeEmptyGroups = true;
    protected AttributeMap attributes = null;
    protected transient int updateLevel = 0;
    protected transient Set transAddedCells = null;
    protected transient Set transRemovedCells = null;
    protected transient Map transEditAttrs = null;
    protected transient ConnectionSet transEditCS = null;
    protected transient ParentMap transEditPM = null;

    public DefaultGraphModel() {
        this(null, null);
    }

    public DefaultGraphModel(List roots, AttributeMap attributes) {
        this.roots = roots != null ? roots : new ArrayList();
        this.attributes = attributes != null ? attributes : new AttributeMap();
    }

    public DefaultGraphModel(List roots, AttributeMap attributes, ConnectionSet cs) {
        this(roots, attributes);
        this.handleConnectionSet(cs);
    }

    public List getRoots() {
        return this.roots;
    }

    @Override
    public int getRootCount() {
        return this.roots.size();
    }

    @Override
    public Object getRootAt(int index) {
        return this.roots.get(index);
    }

    @Override
    public int getIndexOfRoot(Object root) {
        return this.roots.indexOf(root);
    }

    @Override
    public boolean contains(Object node) {
        Object parentNode = null;
        while ((parentNode = this.getParent(node)) != null) {
            node = parentNode;
        }
        return this.roots.contains(node);
    }

    @Override
    public AttributeMap getAttributes(Object node) {
        if (node instanceof GraphCell) {
            return ((GraphCell)node).getAttributes();
        }
        if (node == null) {
            return this.attributes;
        }
        return null;
    }

    @Override
    public Object getValue(Object cell) {
        if (cell instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)cell).getUserObject();
        }
        return null;
    }

    public Map getAttributes() {
        return this.getAttributes(null);
    }

    @Override
    public Object getSource(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getSource();
        }
        return null;
    }

    @Override
    public Object getTarget(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getTarget();
        }
        return null;
    }

    @Override
    public boolean acceptsSource(Object edge, Object port) {
        return true;
    }

    @Override
    public boolean acceptsTarget(Object edge, Object port) {
        return true;
    }

    @Override
    public Iterator edges(Object port) {
        if (port instanceof Port) {
            return ((Port)port).edges();
        }
        return this.emptyIterator;
    }

    @Override
    public boolean isEdge(Object edge) {
        return edge instanceof Edge;
    }

    @Override
    public boolean isPort(Object port) {
        return port instanceof Port;
    }

    public ConnectionSet getConnectionSet() {
        return ConnectionSet.create(this, DefaultGraphModel.getAll(this), false);
    }

    @Override
    public Map cloneCells(Object[] cells) {
        Hashtable<Object, Object> map = new Hashtable<Object, Object>();
        for (int i = 0; i < cells.length; ++i) {
            map.put(cells[i], this.cloneCell(cells[i]));
        }
        for (Map.Entry entry : map.entrySet()) {
            Port anchor;
            Object obj = entry.getValue();
            Object cell = entry.getKey();
            Object parent = this.getParent(cell);
            if (parent != null) {
                parent = map.get(parent);
            }
            if (parent != null) {
                ((DefaultMutableTreeNode)parent).add((DefaultMutableTreeNode)obj);
            }
            if (!(obj instanceof Port) || (anchor = ((Port)obj).getAnchor()) == null) continue;
            ((Port)obj).setAnchor((Port)map.get(anchor));
        }
        return map;
    }

    protected void setParent(Object child, Object parent) {
        if (child instanceof DefaultMutableTreeNode && parent instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent;
            parentNode.add((DefaultMutableTreeNode)child);
        }
    }

    protected Object cloneCell(Object cellObj) {
        if (cellObj instanceof DefaultGraphCell) {
            DefaultGraphCell cell = (DefaultGraphCell)cellObj;
            DefaultGraphCell clone = (DefaultGraphCell)cell.clone();
            clone.setUserObject(this.cloneUserObject(cell.getUserObject()));
            return clone;
        }
        return cellObj;
    }

    protected Object cloneUserObject(Object userObject) {
        return userObject;
    }

    @Override
    public Object getParent(Object child) {
        if (child != null && child instanceof TreeNode) {
            return ((TreeNode)child).getParent();
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)parent).getChildAt(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)parent).getChildCount();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (this.asksAllowsChildren && node instanceof TreeNode) {
            return !((TreeNode)node).getAllowsChildren();
        }
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public void insert(Object[] roots, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        if (this.updateLevel > 0) {
            this.updateTransaction(roots, null, attributes, cs, pm);
        } else {
            GraphModelEdit edit = this.createEdit(roots, null, attributes, cs, pm, edits);
            if (edit != null) {
                edit.execute();
                if (edits != null) {
                    for (int i = 0; i < edits.length; ++i) {
                        if (!(edits[i] instanceof GraphLayoutCache.GraphLayoutCacheEdit)) continue;
                        ((GraphLayoutCache.GraphLayoutCacheEdit)edits[i]).execute();
                    }
                }
                this.postEdit(edit);
            }
        }
    }

    @Override
    public void remove(Object[] roots) {
        if (this.updateLevel > 0) {
            this.updateTransaction(null, roots, null, null, null);
        } else {
            GraphModelEdit edit = this.createRemoveEdit(roots);
            if (edit != null) {
                edit.execute();
                this.postEdit(edit);
            }
        }
    }

    @Override
    public void edit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        this.edit(null, null, attributes, cs, pm, edits);
    }

    public void edit(Object[] inserted, Object[] removed, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        if (this.updateLevel > 0) {
            this.updateTransaction(inserted, removed, attributes, cs, pm);
        } else if (!(inserted != null && inserted.length != 0 || removed != null && removed.length != 0 || attributes != null && !attributes.isEmpty() || cs != null && !cs.isEmpty() || pm != null || edits == null || edits.length != 1)) {
            if (edits[0] instanceof GraphLayoutCache.GraphLayoutCacheEdit) {
                ((GraphLayoutCache.GraphLayoutCacheEdit)edits[0]).execute();
            }
            this.postEdit(edits[0]);
        } else {
            GraphModelEdit edit = this.createEdit(inserted, removed, attributes, cs, pm, edits);
            if (edit != null) {
                edit.execute();
                if (edits != null) {
                    for (int i = 0; i < edits.length; ++i) {
                        if (!(edits[i] instanceof GraphLayoutCache.GraphLayoutCacheEdit)) continue;
                        ((GraphLayoutCache.GraphLayoutCacheEdit)edits[i]).execute();
                    }
                }
                this.postEdit(edit);
            }
        }
    }

    @Override
    public synchronized void execute(ExecutableChange change) {
    }

    @Override
    public int getUpdateLevel() {
        return this.updateLevel;
    }

    @Override
    public void beginUpdate() {
        ++this.updateLevel;
        if (this.updateLevel == 1) {
            this.transEditAttrs = new Hashtable();
            this.transEditCS = new ConnectionSet();
            this.transEditPM = new ParentMap();
            this.transAddedCells = new HashSet();
            this.transRemovedCells = new HashSet();
        }
    }

    @Override
    public void endUpdate() {
        GraphModelEdit edit;
        --this.updateLevel;
        if (this.updateLevel == 0 && (edit = this.createEdit(this.transAddedCells.toArray(), this.transRemovedCells.toArray(), this.transEditAttrs, this.transEditCS, this.transEditPM, null)) != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    protected void updateTransaction(Object[] inserted, Object[] removed, Map attributes, ConnectionSet cs, ParentMap pm) {
        int i;
        if (inserted != null && inserted.length > 0) {
            for (i = 0; i < inserted.length; ++i) {
                if (this.transRemovedCells.contains(inserted[i])) {
                    this.transRemovedCells.remove(inserted[i]);
                    continue;
                }
                this.transAddedCells.add(inserted[i]);
            }
        }
        if (removed != null && removed.length > 0) {
            for (i = 0; i < removed.length; ++i) {
                if (this.transAddedCells.contains(removed[i])) {
                    this.transAddedCells.remove(removed[i]);
                    continue;
                }
                this.transRemovedCells.add(removed[i]);
            }
        }
        if (attributes != null) {
            GraphConstants.merge(attributes, this.transEditAttrs);
        }
        if (cs != null) {
            Set connections = this.transEditCS.getConnections();
            connections.addAll(cs.getConnections());
            this.transEditCS.setConnections(connections);
            Set edges = this.transEditCS.getEdges();
            edges.addAll(cs.getEdges());
            this.transEditCS.setEdges(edges);
        }
        if (pm != null) {
            Iterator entries = pm.entries();
            while (entries.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)entries.next();
                this.transEditPM.addEntry(entry.getChild(), entry.getParent());
            }
        }
    }

    @Override
    public void toBack(Object[] cells) {
        GraphModelLayerEdit edit = this.createLayerEdit(cells, -2);
        if (edit != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    @Override
    public void toFront(Object[] cells) {
        GraphModelLayerEdit edit = this.createLayerEdit(cells, -1);
        if (edit != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    protected GraphModelLayerEdit createLayerEdit(Object[] cells, int layer) {
        return new GraphModelLayerEdit(cells, layer);
    }

    protected GraphModelEdit createRemoveEdit(Object[] cells) {
        ParentMap pm;
        ConnectionSet cs = ConnectionSet.create(this, cells, true);
        GraphModelEdit edit = this.createEdit(null, cells, null, cs, pm = ParentMap.create(this, cells, true, false), null);
        if (edit != null) {
            edit.end();
        }
        return edit;
    }

    protected GraphModelEdit createEdit(Object[] inserted, Object[] removed, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        GraphModelEdit edit = new GraphModelEdit(inserted, removed, attributes, cs, pm);
        if (edit != null) {
            if (edits != null) {
                for (int i = 0; i < edits.length; ++i) {
                    edit.addEdit(edits[i]);
                }
            }
            edit.end();
        }
        return edit;
    }

    protected Object[] handleInsert(Object[] cells) {
        Object[] inserted = null;
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                if (this.getParent(cells[i]) != null) continue;
                this.roots.add(cells[i]);
            }
            inserted = DefaultGraphModel.getDescendants(this, cells).toArray();
        }
        return inserted;
    }

    protected Object[] handleRemove(Object[] cells) {
        HashSet<Object> removedRoots = new HashSet<Object>();
        if (cells != null && cells.length > 0) {
            HashSet rootsSet = new HashSet(this.roots);
            for (int i = 0; i < cells.length; ++i) {
                if (this.getParent(cells[i]) != null || !rootsSet.contains(cells[i])) continue;
                removedRoots.add(cells[i]);
            }
            if (removedRoots.size() > 0) {
                int newRootsSize = this.roots.size() - removedRoots.size();
                if (newRootsSize < 8) {
                    newRootsSize = 8;
                }
                ArrayList newRoots = new ArrayList(newRootsSize);
                for (Object cell : this.roots) {
                    if (removedRoots.contains(cell)) continue;
                    newRoots.add(cell);
                }
                this.roots = newRoots;
            }
        }
        return removedRoots.toArray();
    }

    protected ParentMap handleParentMap(ParentMap parentMap) {
        if (parentMap != null) {
            ParentMap undo = new ParentMap();
            HashSet<Object> rootsSet = null;
            HashSet<Object> rootsToBeRemoved = null;
            Iterator it = parentMap.entries();
            while (it.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)it.next();
                Object child = entry.getChild();
                Object parent = entry.getParent();
                undo.addEntry(child, this.getParent(child));
                if (parent == null) {
                    if (child instanceof MutableTreeNode) {
                        ((MutableTreeNode)child).removeFromParent();
                    }
                } else if (parent instanceof DefaultMutableTreeNode && child instanceof MutableTreeNode) {
                    ((DefaultMutableTreeNode)parent).add((MutableTreeNode)child);
                }
                if (rootsSet == null) {
                    rootsSet = new HashSet<Object>(this.roots);
                }
                boolean isRoot = rootsSet.contains(child);
                if (parent == null && !isRoot) {
                    rootsSet.add(child);
                    this.roots.add(child);
                    continue;
                }
                if (parent == null || !isRoot) continue;
                if (rootsToBeRemoved == null) {
                    rootsToBeRemoved = new HashSet<Object>();
                }
                rootsSet.remove(child);
                rootsToBeRemoved.add(child);
            }
            if (rootsToBeRemoved != null && rootsToBeRemoved.size() > 0) {
                int newRootsSize = this.roots.size() - rootsToBeRemoved.size();
                if (newRootsSize < 8) {
                    newRootsSize = 8;
                }
                ArrayList newRoots = new ArrayList(newRootsSize);
                for (Object cell : this.roots) {
                    if (rootsToBeRemoved.contains(cell)) continue;
                    newRoots.add(cell);
                }
                this.roots = newRoots;
            }
            return undo;
        }
        return null;
    }

    protected Map handleAttributes(Map attributes) {
        if (attributes != null) {
            Hashtable undo = new Hashtable(attributes.size());
            for (Map.Entry entry : attributes.entrySet()) {
                Object cell = entry.getKey();
                Map deltaNew = (Map)entry.getValue();
                Hashtable deltaOld = null;
                AttributeMap attr = this.getAttributes(cell);
                if (attr != null) {
                    deltaOld = attr.applyMap(deltaNew);
                    undo.put(cell, (AttributeMap)deltaOld);
                } else {
                    deltaOld = new Hashtable(2);
                }
                Object newValue = deltaNew.get("value");
                if (newValue != null) {
                    Object oldValue = this.valueForCellChanged(cell, newValue);
                    if (oldValue != null) {
                        GraphConstants.setValue(deltaOld, oldValue);
                        continue;
                    }
                    GraphConstants.setRemoveAttributes(deltaOld, new Object[]{"value"});
                    continue;
                }
                Object[] remove = GraphConstants.getRemoveAttributes(deltaNew);
                if (remove == null || remove.length <= 0) continue;
                for (int i = 0; i < remove.length; ++i) {
                    Object oldValue;
                    if (remove[i] != "value" || (oldValue = this.valueForCellChanged(cell, null)) == null) continue;
                    GraphConstants.setValue(deltaOld, oldValue);
                }
            }
            return undo;
        }
        return null;
    }

    @Override
    public Object valueForCellChanged(Object cell, Object newValue) {
        if (cell instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)cell;
            Object oldValue = node.getUserObject();
            node.setUserObject(newValue);
            return oldValue;
        }
        return null;
    }

    protected ConnectionSet handleConnectionSet(ConnectionSet cs) {
        if (cs != null) {
            ConnectionSet csundo = new ConnectionSet();
            Iterator it = cs.connections();
            while (it.hasNext()) {
                ConnectionSet.Connection c = (ConnectionSet.Connection)it.next();
                Object edge = c.getEdge();
                if (c.isSource()) {
                    csundo.connect(edge, this.getSource(edge), true);
                } else {
                    csundo.connect(edge, this.getTarget(edge), false);
                }
                this.handleConnection(c, false);
            }
            it = cs.connections();
            while (it.hasNext()) {
                this.handleConnection((ConnectionSet.Connection)it.next(), true);
            }
            return csundo;
        }
        return null;
    }

    protected void handleConnection(ConnectionSet.Connection c, boolean establish) {
        Object edge = c.getEdge();
        Object port = establish ? c.getPort() : (c.isSource() ? this.getSource(edge) : this.getTarget(edge));
        this.connect(edge, port, c.isSource(), establish);
    }

    protected void connect(Object edge, Object port, boolean isSource, boolean insert) {
        if (port instanceof Port) {
            if (insert) {
                ((Port)port).addEdge(edge);
            } else if (isSource ? this.getTarget(edge) != port : this.getSource(edge) != port) {
                ((Port)port).removeEdge(edge);
            }
        }
        if (!insert) {
            port = null;
        }
        if (edge instanceof Edge) {
            if (isSource) {
                ((Edge)edge).setSource(port);
            } else {
                ((Edge)edge).setTarget(port);
            }
        }
    }

    @Override
    public void addGraphModelListener(GraphModelListener l) {
        this.listenerList.add(GraphModelListener.class, l);
    }

    @Override
    public void removeGraphModelListener(GraphModelListener l) {
        this.listenerList.remove(GraphModelListener.class, l);
    }

    public void cellsChanged(final Object[] cells) {
        if (cells != null) {
            this.fireGraphChanged(this, new GraphModelEvent.GraphModelChange(){

                @Override
                public Object[] getInserted() {
                    return null;
                }

                @Override
                public Object[] getRemoved() {
                    return null;
                }

                @Override
                public Map getPreviousAttributes() {
                    return null;
                }

                @Override
                public ConnectionSet getConnectionSet() {
                    return null;
                }

                @Override
                public ConnectionSet getPreviousConnectionSet() {
                    return null;
                }

                @Override
                public ParentMap getParentMap() {
                    return null;
                }

                @Override
                public ParentMap getPreviousParentMap() {
                    return null;
                }

                @Override
                public void putViews(GraphLayoutCache view, CellView[] cellViews) {
                }

                @Override
                public CellView[] getViews(GraphLayoutCache view) {
                    return null;
                }

                @Override
                public Object getSource() {
                    return this;
                }

                @Override
                public Object[] getChanged() {
                    return cells;
                }

                @Override
                public Map getAttributes() {
                    return null;
                }

                @Override
                public Object[] getContext() {
                    return null;
                }

                @Override
                public Rectangle2D getDirtyRegion() {
                    return null;
                }

                @Override
                public void setDirtyRegion(Rectangle2D dirty) {
                }
            });
        }
    }

    protected void fireGraphChanged(Object source, GraphModelEvent.GraphModelChange edit) {
        Object[] listeners = this.listenerList.getListenerList();
        GraphModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GraphModelListener.class) continue;
            if (e == null) {
                e = new GraphModelEvent(source, edit);
            }
            ((GraphModelListener)listeners[i + 1]).graphChanged(e);
        }
    }

    public GraphModelListener[] getGraphModelListeners() {
        return (GraphModelListener[])this.listenerList.getListeners(GraphModelListener.class);
    }

    public static Object cloneCell(GraphModel model, Object cell) {
        Map clones = model.cloneCells(DefaultGraphModel.getDescendants(model, new Object[]{cell}).toArray());
        return clones.get(cell);
    }

    public static Object[] cloneCell(GraphModel model, Object[] cells) {
        Map clones = model.cloneCells(DefaultGraphModel.getDescendants(model, cells).toArray());
        for (int i = 0; i < cells.length; ++i) {
            cells[i] = clones.get(cells[i]);
        }
        return cells;
    }

    public static void setSourcePort(GraphModel model, Object edge, Object port) {
        model.edit(null, new ConnectionSet(edge, port, true), null, null);
    }

    public static void setTargetPort(GraphModel model, Object edge, Object port) {
        model.edit(null, new ConnectionSet(edge, port, false), null, null);
    }

    public static Object getSourceVertex(GraphModel model, Object edge) {
        if (model != null) {
            return model.getParent(model.getSource(edge));
        }
        return null;
    }

    public static Object getTargetVertex(GraphModel model, Object edge) {
        if (model != null) {
            return model.getParent(model.getTarget(edge));
        }
        return null;
    }

    public static Object getUserObject(Object cell) {
        if (cell instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)cell).getUserObject();
        }
        return null;
    }

    public static boolean isGroup(GraphModel model, Object cell) {
        for (int i = 0; i < model.getChildCount(cell); ++i) {
            if (model.isPort(model.getChild(cell, i))) continue;
            return true;
        }
        return false;
    }

    public static Object[] getAll(GraphModel model) {
        return DefaultGraphModel.getDescendants(model, DefaultGraphModel.getRoots(model)).toArray();
    }

    public static Object[] getRoots(GraphModel model) {
        Object[] cells = null;
        if (model != null) {
            if (model instanceof DefaultGraphModel) {
                cells = ((DefaultGraphModel)model).getRoots().toArray();
            } else {
                cells = new Object[model.getRootCount()];
                for (int i = 0; i < cells.length; ++i) {
                    cells[i] = model.getRootAt(i);
                }
            }
        }
        return cells;
    }

    public static Collection getRootsAsCollection(GraphModel model) {
        SequencedCollection<Object> cells = null;
        if (model != null) {
            if (model instanceof DefaultGraphModel) {
                cells = ((DefaultGraphModel)model).getRoots();
            } else {
                cells = new LinkedHashSet(model.getRootCount());
                for (int i = 0; i < cells.size(); ++i) {
                    cells.add(model.getRootAt(i));
                }
            }
        }
        return cells;
    }

    public static Object[] getRoots(GraphModel model, Object[] cells) {
        ArrayList<Object> roots = new ArrayList<Object>();
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                if (model.getParent(cells[i]) != null) continue;
                roots.add(cells[i]);
            }
        }
        return roots.toArray();
    }

    public static Object[] getTopmostCells(GraphModel model, Object[] cells) {
        HashSet<Object> cellSet = new HashSet<Object>();
        for (int i = 0; i < cells.length; ++i) {
            cellSet.add(cells[i]);
        }
        ArrayList<Object> parents = new ArrayList<Object>();
        for (int i = 0; i < cells.length; ++i) {
            if (DefaultGraphModel.hasAncestorIn(model, cellSet, cells[i])) continue;
            parents.add(cells[i]);
        }
        return parents.toArray();
    }

    public static boolean hasAncestorIn(GraphModel model, Set parents, Object child) {
        Object parent = model.getParent(child);
        while (parent != null) {
            if (parents.contains(parent)) {
                return true;
            }
            parent = model.getParent(parent);
        }
        return false;
    }

    public static List getDescendants(GraphModel model, Object[] cells) {
        if (cells != null) {
            Stack<Object> stack = new Stack<Object>();
            for (int i = cells.length - 1; i >= 0; --i) {
                stack.add(cells[i]);
            }
            LinkedList result = new LinkedList();
            while (!stack.isEmpty()) {
                Object tmp = stack.pop();
                for (int i = model.getChildCount(tmp) - 1; i >= 0; --i) {
                    stack.add(model.getChild(tmp, i));
                }
                if (tmp == null) continue;
                result.add(tmp);
            }
            return result;
        }
        return null;
    }

    public static Object[] order(GraphModel model, Object[] cells) {
        if (cells != null) {
            HashSet<Object> cellSet = new HashSet<Object>();
            for (int i = 0; i < cells.length; ++i) {
                cellSet.add(cells[i]);
            }
            Stack<Object> stack = new Stack<Object>();
            for (int i = model.getRootCount() - 1; i >= 0; --i) {
                stack.add(model.getRootAt(i));
            }
            LinkedList result = new LinkedList();
            while (!stack.isEmpty()) {
                Object tmp = stack.pop();
                for (int i = model.getChildCount(tmp) - 1; i >= 0; --i) {
                    stack.add(model.getChild(tmp, i));
                }
                if (!cellSet.remove(tmp)) continue;
                result.add(tmp);
            }
            return result.toArray();
        }
        return null;
    }

    public static Set getEdges(GraphModel model, Object[] cells) {
        LinkedHashSet result = new LinkedHashSet();
        if (cells != null) {
            int setSize = (int)((double)cells.length * 1.33) + 1;
            HashSet<Object> allCells = new HashSet<Object>(setSize, 0.75f);
            for (int i = 0; i < cells.length; ++i) {
                allCells.add(cells[i]);
            }
            List descendants = DefaultGraphModel.getDescendants(model, cells);
            Iterator desIter = descendants.iterator();
            while (desIter.hasNext()) {
                allCells.add(desIter.next());
            }
            if (allCells != null) {
                Iterator it = allCells.iterator();
                while (it.hasNext()) {
                    Iterator edges = model.edges(it.next());
                    while (edges.hasNext()) {
                        result.add(edges.next());
                    }
                }
                for (int i = 0; i < cells.length; ++i) {
                    result.remove(cells[i]);
                }
            }
        }
        return result;
    }

    public static Object getOpposite(GraphModel model, Object edge, Object cell) {
        Object source;
        boolean isPort = model.isPort(cell);
        Object object = source = isPort ? model.getSource(edge) : DefaultGraphModel.getSourceVertex(model, edge);
        if (cell == source) {
            return isPort ? model.getTarget(edge) : DefaultGraphModel.getTargetVertex(model, edge);
        }
        return source;
    }

    public static boolean containsEdgeBetween(GraphModel model, Object v1, Object v2) {
        Object[] edges = DefaultGraphModel.getEdgesBetween(model, v1, v2, false);
        return edges != null && edges.length > 0;
    }

    public static Object[] getEdgesBetween(GraphModel model, Object cell1, Object cell2, boolean directed) {
        boolean isPort1 = model.isPort(cell1);
        boolean isPort2 = model.isPort(cell2);
        ArrayList result = new ArrayList();
        Set edges = DefaultGraphModel.getEdges(model, new Object[]{cell1});
        for (Object edge : edges) {
            Object target;
            Object source = isPort1 ? model.getSource(edge) : DefaultGraphModel.getSourceVertex(model, edge);
            Object object = target = isPort2 ? model.getTarget(edge) : DefaultGraphModel.getTargetVertex(model, edge);
            if ((source != cell1 || target != cell2) && (directed || source != cell2 || target != cell1)) continue;
            result.add(edge);
        }
        return result.toArray();
    }

    public static Object[] getOutgoingEdges(GraphModel model, Object cell) {
        return DefaultGraphModel.getEdges(model, cell, false);
    }

    public static Object[] getIncomingEdges(GraphModel model, Object cell) {
        return DefaultGraphModel.getEdges(model, cell, true);
    }

    public static Object[] getEdges(GraphModel model, Object cell, boolean incoming) {
        Set edges = DefaultGraphModel.getEdges(model, new Object[]{cell});
        ArrayList result = new ArrayList(edges.size());
        for (Object edge : edges) {
            Object port = incoming ? model.getTarget(edge) : model.getSource(edge);
            Object parent = model.getParent(port);
            if (port != cell && parent != cell) continue;
            result.add(edge);
        }
        return result.toArray();
    }

    public static boolean isVertex(GraphModel model, Object vertex) {
        return vertex != null && !model.isEdge(vertex) && !model.isPort(vertex);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.emptyIterator = new EmptyIterator();
    }

    public boolean isRemoveEmptyGroups() {
        return this.removeEmptyGroups;
    }

    public void setRemoveEmptyGroups(boolean removeEmptyGroups) {
        this.removeEmptyGroups = removeEmptyGroups;
    }

    public static class EmptyIterator
    implements Iterator,
    Serializable {
        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    public class GraphModelLayerEdit
    extends AbstractUndoableEdit
    implements GraphModelEvent.GraphModelChange {
        public static final int FRONT = -1;
        public static final int BACK = -2;
        protected Object changeSource;
        protected transient Object[] cells;
        protected transient int[] next;
        protected transient int[] prev;
        protected int layer;
        protected Object[] changed;

        public GraphModelLayerEdit(Object[] cells, int layer) {
            this.cells = cells;
            this.layer = layer;
            this.next = new int[cells.length];
            this.prev = new int[cells.length];
            this.updateNext();
            HashSet<Object> par = new HashSet<Object>();
            for (int i = 0; i < cells.length; ++i) {
                Object cell = DefaultGraphModel.this.getParent(cells[i]);
                if (cell == null) {
                    cell = cells[i];
                }
                par.add(cell);
            }
            this.changed = par.toArray();
        }

        protected void updateNext() {
            for (int i = 0; i < this.next.length; ++i) {
                this.next[i] = this.layer;
            }
        }

        @Override
        public Object getSource() {
            return DefaultGraphModel.this;
        }

        @Override
        public Object[] getChanged() {
            return this.changed;
        }

        @Override
        public Object[] getInserted() {
            return null;
        }

        @Override
        public Object[] getRemoved() {
            return null;
        }

        @Override
        public Object[] getContext() {
            return null;
        }

        @Override
        public Map getAttributes() {
            return null;
        }

        @Override
        public Map getPreviousAttributes() {
            return null;
        }

        @Override
        public ConnectionSet getConnectionSet() {
            return null;
        }

        @Override
        public ConnectionSet getPreviousConnectionSet() {
            return null;
        }

        @Override
        public ParentMap getParentMap() {
            return null;
        }

        @Override
        public ParentMap getPreviousParentMap() {
            return null;
        }

        @Override
        public Rectangle2D getDirtyRegion() {
            return null;
        }

        @Override
        public void setDirtyRegion(Rectangle2D dirty) {
        }

        public void addImplicitEdit(UndoableEdit edit) {
        }

        @Override
        public CellView[] getViews(GraphLayoutCache view) {
            return null;
        }

        @Override
        public void putViews(GraphLayoutCache view, CellView[] cellViews) {
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.updateNext();
            this.execute();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            for (int i = 0; i < this.cells.length; ++i) {
                List list = this.getParentList(this.cells[i]);
                if (list == null) continue;
                this.prev[i] = list.indexOf(this.cells[i]);
                if (this.prev[i] < 0) continue;
                list.remove(this.prev[i]);
                int n = this.next[i];
                if (n == -1) {
                    n = list.size();
                } else if (n == -2) {
                    n = 0;
                }
                list.add(n, this.cells[i]);
                this.next[i] = this.prev[i];
            }
            this.updateListeners();
        }

        protected void updateListeners() {
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        protected List getParentList(Object cell) {
            List list = null;
            if (cell instanceof DefaultMutableTreeNode) {
                TreeNode parent = ((DefaultMutableTreeNode)cell).getParent();
                list = parent instanceof DefaultGraphCell ? ((DefaultGraphCell)parent).getChildren() : DefaultGraphModel.this.roots;
            }
            return list;
        }
    }

    public class GraphModelEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphModelChange {
        protected Object[] insert;
        protected Object[] changed;
        protected Object[] remove;
        protected Object[] context;
        protected Object[] inserted;
        protected Object[] removed;
        protected Map attributes;
        protected Map previousAttributes;
        protected ParentMap parentMap;
        protected ParentMap previousParentMap;
        protected Rectangle2D dirtyRegion = null;
        protected ConnectionSet connectionSet;
        protected ConnectionSet previousConnectionSet;
        protected Map cellViews = new Hashtable();

        public GraphModelEdit(Object[] inserted, Object[] removed, Map attributes, ConnectionSet connectionSet, ParentMap parentMap) {
            this.insert = inserted;
            this.remove = removed;
            this.connectionSet = connectionSet;
            this.attributes = attributes;
            this.parentMap = parentMap;
            this.previousAttributes = null;
            this.previousConnectionSet = connectionSet;
            this.previousParentMap = parentMap;
            if (parentMap != null) {
                Hashtable childCount = new Hashtable();
                Iterator it = parentMap.entries();
                while (it.hasNext()) {
                    Object newParent;
                    Object oldParent;
                    ParentMap.Entry entry = (ParentMap.Entry)it.next();
                    Object child = entry.getChild();
                    if (DefaultGraphModel.this.isPort(child) || (oldParent = DefaultGraphModel.this.getParent(child)) == (newParent = entry.getParent())) continue;
                    this.changeChildCount(childCount, oldParent, -1);
                    this.changeChildCount(childCount, newParent, 1);
                }
                this.handleEmptyGroups(this.filterParents(childCount, 0));
            }
        }

        public Object[] filterParents(Map childCount, int children) {
            ArrayList list = new ArrayList();
            for (Map.Entry entry : childCount.entrySet()) {
                if (!(entry.getValue() instanceof Integer) || (Integer)entry.getValue() != children) continue;
                list.add(entry.getKey());
            }
            return list.toArray();
        }

        protected void changeChildCount(Map childCount, Object parent, int change) {
            if (parent != null) {
                Integer count = (Integer)childCount.get(parent);
                if (count == null) {
                    count = new Integer(DefaultGraphModel.this.getChildCount(parent));
                }
                int newValue = count + change;
                childCount.put(parent, new Integer(newValue));
            }
        }

        protected void handleEmptyGroups(Object[] groups) {
            if (DefaultGraphModel.this.removeEmptyGroups && groups != null && groups.length > 0) {
                if (this.remove == null) {
                    this.remove = new Object[0];
                }
                Object[] tmp = new Object[this.remove.length + groups.length];
                System.arraycopy(this.remove, 0, tmp, 0, this.remove.length);
                System.arraycopy(groups, 0, tmp, this.remove.length, groups.length);
                this.remove = tmp;
            }
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public Object getSource() {
            return DefaultGraphModel.this;
        }

        @Override
        public Object[] getChanged() {
            return this.changed;
        }

        @Override
        public Object[] getContext() {
            return this.context;
        }

        @Override
        public Object[] getInserted() {
            return this.inserted;
        }

        @Override
        public Object[] getRemoved() {
            return this.removed;
        }

        @Override
        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        @Override
        public Map getAttributes() {
            return this.attributes;
        }

        @Override
        public ConnectionSet getConnectionSet() {
            return this.connectionSet;
        }

        @Override
        public ConnectionSet getPreviousConnectionSet() {
            return this.previousConnectionSet;
        }

        @Override
        public ParentMap getParentMap() {
            return this.parentMap;
        }

        @Override
        public ParentMap getPreviousParentMap() {
            return this.previousParentMap;
        }

        @Override
        public Rectangle2D getDirtyRegion() {
            return this.dirtyRegion;
        }

        @Override
        public void setDirtyRegion(Rectangle2D dirty) {
            this.dirtyRegion = dirty;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            HashSet tmp = new HashSet();
            if (this.attributes != null) {
                tmp.addAll(this.attributes.keySet());
            }
            if (this.parentMap != null) {
                tmp.addAll(this.parentMap.getChangedNodes());
            }
            if (this.connectionSet != null) {
                tmp.addAll(this.connectionSet.getChangedEdges());
            }
            if (this.remove != null) {
                for (int i = 0; i < this.remove.length; ++i) {
                    tmp.remove(this.remove[i]);
                }
            }
            this.changed = tmp.toArray();
            Set ctx = DefaultGraphModel.getEdges(DefaultGraphModel.this, this.changed);
            this.context = ctx.toArray();
            this.inserted = this.insert;
            this.removed = this.remove;
            this.remove = DefaultGraphModel.this.handleInsert(this.inserted);
            this.previousParentMap = this.parentMap;
            this.parentMap = DefaultGraphModel.this.handleParentMap(this.parentMap);
            if (this.parentMap != null) {
                tmp.addAll(this.parentMap.getChangedNodes());
            }
            this.previousConnectionSet = this.connectionSet;
            this.connectionSet = DefaultGraphModel.this.handleConnectionSet(this.connectionSet);
            this.insert = DefaultGraphModel.this.handleRemove(this.removed);
            this.previousAttributes = this.attributes;
            this.attributes = DefaultGraphModel.this.handleAttributes(this.attributes);
            this.changed = tmp.toArray();
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        @Override
        public void putViews(GraphLayoutCache view, CellView[] views) {
            if (view != null && views != null) {
                this.cellViews.put(view, views);
            }
        }

        @Override
        public CellView[] getViews(GraphLayoutCache view) {
            return (CellView[])this.cellViews.get(view);
        }

        @Override
        public String toString() {
            int i;
            String s = new String();
            if (this.inserted != null) {
                s = s + "Inserted:\n";
                for (i = 0; i < this.inserted.length; ++i) {
                    s = s + "  " + this.inserted[i] + "\n";
                }
            } else {
                s = s + "None inserted\n";
            }
            if (this.removed != null) {
                s = s + "Removed:\n";
                for (i = 0; i < this.removed.length; ++i) {
                    s = s + "  " + this.removed[i] + "\n";
                }
            } else {
                s = s + "None removed\n";
            }
            if (this.changed != null && this.changed.length > 0) {
                s = s + "Changed:\n";
                for (i = 0; i < this.changed.length; ++i) {
                    s = s + "  " + this.changed[i] + "\n";
                }
            } else {
                s = s + "None changed\n";
            }
            s = this.parentMap != null ? s + this.parentMap.toString() : s + "No parent map\n";
            return s;
        }
    }
}

