/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.Serializable;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;

public class DefaultCellViewFactory
implements CellViewFactory,
Serializable {
    @Override
    public CellView createView(GraphModel model, Object cell) {
        AbstractCellView view = null;
        view = model.isPort(cell) ? this.createPortView(cell) : (model.isEdge(cell) ? this.createEdgeView(cell) : this.createVertexView(cell));
        return view;
    }

    protected VertexView createVertexView(Object cell) {
        return new VertexView(cell);
    }

    protected EdgeView createEdgeView(Object cell) {
        if (cell instanceof Edge) {
            return this.createEdgeView((Edge)cell);
        }
        return new EdgeView(cell);
    }

    protected PortView createPortView(Object cell) {
        if (cell instanceof Port) {
            return this.createPortView((Port)cell);
        }
        return new PortView(cell);
    }

    protected EdgeView createEdgeView(Edge cell) {
        return new EdgeView(cell);
    }

    protected PortView createPortView(Port cell) {
        return new PortView(cell);
    }
}

