/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.JASIcon;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SpinBox
extends JComponent {
    private int max = 100;
    private int min = 0;
    private int value = 0;
    private int delay = 50;
    private boolean valueChanging = false;
    private JTextField field;
    private JButton plus = new JButton(JASIcon.create(this, "up.gif"));
    private JButton minus = new JButton(JASIcon.create(this, "down.gif"));
    private Vector listener = new Vector();

    public SpinBox(int init, int min, int max) {
        if (min < 0 || max < min || init < min || init > max) {
            throw new IllegalArgumentException("Invalid initial parameters for spin box");
        }
        this.value = init;
        this.min = min;
        this.max = max;
        this.valueChanging = true;
        this.field = new JTextField(new SpinDocument(), String.valueOf(init), (int)(1.0 + Math.log(Math.abs(max)) / Math.log(10.0)));
        this.valueChanging = false;
        this.valueChanged();
        this.plus.setMargin(new Insets(0, 0, 0, 0));
        this.plus.setModel(new MachineGunButtonModel());
        this.minus.setMargin(new Insets(0, 0, 0, 0));
        this.minus.setModel(new MachineGunButtonModel());
        this.setLayout(new FlowLayout(1, 0, 0));
        JPanel p = new JPanel(new BorderLayout(0, 0));
        p.add("North", this.plus);
        p.add("South", this.minus);
        this.add(this.field);
        this.add(p);
        this.plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpinBox.this.value++;
                SpinBox.this.valueChanged();
            }
        });
        this.minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpinBox.this.value--;
                SpinBox.this.valueChanged();
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.listener.addElement(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listener.removeElement(l);
    }

    private void fireActionListener() {
        ActionEvent event = new ActionEvent(this, 1001, "hi");
        Enumeration e = this.listener.elements();
        while (e.hasMoreElements()) {
            ((ActionListener)e.nextElement()).actionPerformed(event);
        }
    }

    private void valueChanged() {
        if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
        this.plus.setEnabled(this.value < this.max);
        this.minus.setEnabled(this.value > this.min);
        if (!this.valueChanging) {
            this.valueChanging = true;
            this.field.setText(String.valueOf(this.value));
            this.valueChanging = false;
        }
        this.fireActionListener();
    }

    public void setMin(int value) {
        this.min = value;
    }

    public void setMax(int value) {
        this.max = value;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.valueChanged();
    }

    public int getRepeatDelay() {
        return this.delay;
    }

    public void setRepeatDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Invalid repeatDelay set");
        }
        this.delay = delay;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.plus.setEnabled(enabled);
        this.minus.setEnabled(enabled);
        this.field.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame();
        frame.setContentPane(new SpinBox(50, 1, 999));
        frame.pack();
        frame.show();
    }

    private class SpinDocument
    extends PlainDocument
    implements Runnable {
        private SpinDocument() {
        }

        @Override
        public void insertString(int pos, String string, AttributeSet p3) throws BadLocationException {
            if (!SpinBox.this.valueChanging) {
                for (int i = 0; i < string.length(); ++i) {
                    if (Character.isDigit(string.charAt(i))) continue;
                    SpinBox.this.getToolkit().beep();
                    return;
                }
            }
            super.insertString(pos, string, p3);
            if (!SpinBox.this.valueChanging) {
                int nValue = Integer.parseInt(SpinBox.this.field.getText());
                if (nValue < SpinBox.this.min || nValue > SpinBox.this.max) {
                    super.remove(pos, string.length());
                    SpinBox.this.getToolkit().beep();
                    return;
                }
                SpinBox.this.value = nValue;
                SpinBox.this.valueChanging = true;
                SpinBox.this.valueChanged();
                SpinBox.this.valueChanging = false;
            }
        }

        @Override
        public void remove(int pos, int len) throws BadLocationException {
            super.remove(pos, len);
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            if (SpinBox.this.field == null) {
                return;
            }
            String text = SpinBox.this.field.getText();
            int nValue = text.length() == 0 ? Integer.MIN_VALUE : Integer.parseInt(SpinBox.this.field.getText());
            if (nValue < SpinBox.this.min) {
                nValue = SpinBox.this.min;
                SpinBox.this.getToolkit().beep();
                SpinBox.this.field.setText(String.valueOf(nValue));
            }
            SpinBox.this.value = nValue;
            SpinBox.this.valueChanging = true;
            SpinBox.this.valueChanged();
            SpinBox.this.valueChanging = false;
        }
    }

    private class MachineGunButtonModel
    extends DefaultButtonModel
    implements ActionListener {
        private Timer timer;

        private MachineGunButtonModel() {
        }

        @Override
        public void setPressed(boolean b) {
            if (!b && this.timer != null && this.timer.isRunning()) {
                this.timer.stop();
            }
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            if (this.isPressed() && this.isArmed()) {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }
            if (this.timer == null && this.isPressed() && SpinBox.this.delay > 0) {
                this.timer = new Timer(SpinBox.this.delay, this);
                this.timer.setInitialDelay(500);
            }
            if (this.isPressed()) {
                this.timer.start();
            }
            this.fireStateChanged();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled() && this.isArmed() && this.isPressed()) {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }
        }
    }
}

