/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Application;
import jas.util.UserProperties;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class JASEditableComboBox
extends JComboBox
implements KeyListener {
    private int m_minWidth = -1;
    private int m_maxWidth = -1;
    private int m_nItems;
    private String[] m_dropDownItems;
    private String m_key = null;
    private JTextField m_textField;
    private ChangeEvent m_changeEvent = null;
    private UserProperties m_prop = null;
    private boolean m_clickDefault;

    public JASEditableComboBox(String[] dropDownItems, boolean clickDefault) {
        this.m_clickDefault = clickDefault;
        this.init(dropDownItems);
    }

    public JASEditableComboBox(String key, int nItems, boolean clickDefault) {
        this.m_clickDefault = clickDefault;
        this.m_prop = UserProperties.getUserProperties();
        this.m_nItems = nItems;
        this.m_key = key;
        this.init(this.m_prop.getStringArray(this.m_key, null));
    }

    public JASEditableComboBox(String key, String lengthKey, boolean clickDefault) {
        this(key, Application.getApplication().getUserProperties().getInteger(lengthKey, 4), clickDefault);
    }

    private void init(String[] dropDownItems) {
        this.m_dropDownItems = dropDownItems;
        if (this.m_dropDownItems != null) {
            for (int i = 0; i < this.m_dropDownItems.length; ++i) {
                this.addItem(this.m_dropDownItems[i]);
            }
        }
        this.setEditable(true);
        this.m_textField = (JTextField)this.getEditor().getEditorComponent();
        this.m_textField.addKeyListener(this);
    }

    public void saveState() {
        if (this.m_key != null) {
            this.m_prop.setStringArray(this.m_key, UserProperties.updateStringArray(this.m_dropDownItems, this.getText(), this.m_nItems));
        }
    }

    public String getText() {
        return this.m_textField.getText();
    }

    public void setText(String s) {
        if (s.equals(this.getItemAt(0))) {
            return;
        }
        this.removeItem(s);
        this.insertItemAt(s, 0);
        this.setSelectedIndex(0);
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        if (this.m_textField != null) {
            this.m_textField.addKeyListener(kl);
        }
    }

    @Override
    public final void keyReleased(KeyEvent e) {
    }

    @Override
    public final void keyPressed(KeyEvent e) {
        JButton b;
        if (e.getSource() != this.m_textField) {
            return;
        }
        this.fireStateChanged();
        if (e.getKeyCode() == 10 && this.m_clickDefault && (b = this.getRootPane().getDefaultButton()) != null) {
            b.doClick();
        }
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.m_changeEvent);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.m_textField.addActionListener(l);
    }

    @Override
    protected final void fireItemStateChanged(ItemEvent event) {
        super.fireItemStateChanged(event);
        this.fireStateChanged();
    }

    @Override
    public final void requestFocus() {
        this.m_textField.requestFocus();
    }

    @Override
    public final void keyTyped(KeyEvent e) {
    }

    public final void setMaxWidth(int maxWidth) {
        this.m_maxWidth = maxWidth;
    }

    public final void setMinWidth(int minWidth) {
        this.m_minWidth = minWidth;
    }

    @Override
    public final Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (this.m_maxWidth > 0 && this.m_maxWidth < d.width) {
            d.width = this.m_maxWidth;
        }
        return d;
    }

    @Override
    public final Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (this.m_minWidth > 0 && this.m_minWidth > d.width) {
            d.width = this.m_minWidth;
        }
        return d;
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.m_minWidth > 0 && this.m_minWidth > d.width) {
            d.width = this.m_minWidth;
        }
        if (this.m_maxWidth > 0 && this.m_maxWidth < d.width) {
            d.width = this.m_maxWidth;
        }
        return d;
    }
}

