/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.DocumentOutputStream;
import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.OnScreenPopupMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ErrorBox
extends JASDialog {
    private Throwable m_throw;
    private boolean m_details;
    private JFrame m_frame;

    public ErrorBox(JFrame parent, String message) {
        this(parent, message, null, null);
    }

    public ErrorBox(JFrame parent, String message, String helpTopic) {
        this(parent, message, null, helpTopic);
    }

    public ErrorBox(JFrame parent, String message, Throwable throwable) {
        this(parent, message, throwable, null);
    }

    public ErrorBox(JFrame parent, String message, Throwable throwable, String helpTopic) {
        super((Frame)parent, "Error...", true, 1 | (throwable != null ? 6 : 0) | (helpTopic != null ? 8 : 0));
        if (helpTopic != null) {
            this.setHelpTopic(helpTopic);
        }
        this.init(message, throwable, parent);
    }

    private void init(String m, Throwable t, JFrame parent) {
        this.setApplyLabel("Details");
        this.setApplyMnemonic('D');
        this.setCancelLabel("Traceback");
        this.setCancelMnemonic('T');
        JPanel p = new JPanel();
        p.add(new JLabel(UIManager.getIcon("OptionPane.errorIcon")));
        p.add(new JLabel(m));
        this.getContentPane().add((Component)p, "North");
        this.m_frame = parent;
        this.m_throw = t;
        this.m_details = t != null;
        this.pack();
        this.getToolkit().beep();
    }

    @Override
    protected final void enableApply(JASState state) {
        state.setEnabled(this.m_details);
    }

    @Override
    protected final void onCancel() {
        JTextArea ta = new JTextArea();
        PrintWriter pw = new PrintWriter(new DocumentOutputStream(ta.getDocument()));
        this.m_throw.printStackTrace(pw);
        pw.close();
        ta.setEditable(false);
        ta.addMouseListener(new PopupListener(new PopupMenu(ta)));
        JScrollPane scroll = new JScrollPane(ta);
        scroll.setPreferredSize(new Dimension(500, 300));
        JOptionPane.showMessageDialog(this, scroll, "Traceback...", -1);
    }

    @Override
    protected final void onApply() {
        JTextArea text = new JTextArea(this.m_throw.toString());
        text.setEditable(false);
        text.addMouseListener(new PopupListener(new PopupMenu(text)));
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(text);
        this.getContentPane().add((Component)scroll, "Center");
        this.pack();
        this.m_details = false;
        this.callEnable();
    }

    private static class PopupListener
    extends MouseAdapter {
        private JPopupMenu menu;

        PopupListener(JPopupMenu menu) {
            this.menu = menu;
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.maybePopup(me);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.maybePopup(me);
        }

        private void maybePopup(MouseEvent me) {
            if (this.menu.isPopupTrigger(me)) {
                this.menu.show(me.getComponent(), me.getX(), me.getY());
            }
        }
    }

    private static class PopupMenu
    extends OnScreenPopupMenu
    implements ActionListener {
        private JTextArea parent;
        JMenuItem copy = new JMenuItem("Copy", 67);
        JMenuItem select = new JMenuItem("Select All", 83);

        PopupMenu(JTextArea parent) {
            this.parent = parent;
            this.copy.addActionListener(this);
            this.select.addActionListener(this);
            this.add(this.copy);
            this.add(this.select);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.select) {
                this.parent.selectAll();
            } else if (source == this.copy) {
                this.parent.copy();
            }
        }
    }
}

