/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.ChartLayout;
import jas.plot.DataArea;
import jas.plot.JASPlotMouseListener;
import jas.plot.MovableObject;
import jas.plot.PlotComponent;
import jas.plot.PopupMenuBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class PlotPanel
extends PlotComponent
implements ContainerListener,
MouseListener,
MouseMotionListener {
    private PopupMenuBuilder menuBuilder = new PopupMenuBuilder();
    private MovableObject componentWithHandles;
    private boolean allowUserInteraction = true;
    private boolean allowPopupMenus = true;

    public PlotPanel() {
        super(new ChartLayout());
        this.enableEvents(2L);
        this.enableEvents(16L);
    }

    @Override
    public Component add(Component c) {
        if (c instanceof DataArea) {
            return super.add(c);
        }
        return super.add(c, 0);
    }

    @Override
    protected final void processContainerEvent(ContainerEvent e) {
        if (e.getID() == 300) {
            this.componentAdded(e);
        } else {
            this.componentRemoved(e);
        }
    }

    public void restoreDefaultLayout() {
        ChartLayout cl = (ChartLayout)this.getLayout();
        cl.restoreDefaultLayout();
        this.revalidate();
    }

    public boolean hasDefaultLayout() {
        ChartLayout cl = (ChartLayout)this.getLayout();
        return cl.hasDefaultLayout();
    }

    @Override
    protected final void processMouseEvent(MouseEvent e) {
        if (!this.allowUserInteraction) {
            return;
        }
        if (e.getID() == 501 && this.componentWithHandles != null) {
            this.componentWithHandles.hideHandles();
            this.componentWithHandles = null;
        }
        if (this.allowPopupMenus) {
            this.menuBuilder.buildMenu(e);
        }
    }

    private void propagateMouseMotionEvent(MouseEvent e) {
        if (!this.allowUserInteraction) {
            return;
        }
        Component source = (Component)e.getSource();
        if (this.componentWithHandles != null) {
            this.componentWithHandles.mouseMotionEventNotify(SwingUtilities.convertMouseEvent(source, e, this.componentWithHandles));
        } else {
            for (Component c = source; c != null; c = c.getParent()) {
                if (!(c instanceof MovableObject)) continue;
                ((MovableObject)c).mouseMotionEventNotify(SwingUtilities.convertMouseEvent(source, e, c));
            }
        }
    }

    private void propagateMouseEvent(MouseEvent e) {
        if (!this.allowUserInteraction) {
            return;
        }
        Component source = (Component)e.getSource();
        if (this.componentWithHandles != null) {
            this.componentWithHandles.mouseEventNotify(SwingUtilities.convertMouseEvent(source, e, this.componentWithHandles));
        }
        for (Component c = source; c != null; c = c.getParent()) {
            if (!(c instanceof JASPlotMouseListener)) continue;
            ((JASPlotMouseListener)((Object)c)).mouseEventNotify(SwingUtilities.convertMouseEvent(source, e, c));
        }
        if (this.allowPopupMenus) {
            this.menuBuilder.buildMenu(e);
        }
    }

    private void addComponent(Component comp) {
        comp.addMouseListener(this);
        comp.addMouseMotionListener(this);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addComponent(children[i]);
            }
        }
    }

    private void removeComponent(Component comp) {
        comp.removeMouseListener(this);
        comp.removeMouseMotionListener(this);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeComponent(children[i]);
            }
        }
    }

    public final void deselected() {
        if (this.componentWithHandles != null) {
            this.componentWithHandles.hideHandles();
            this.componentWithHandles = null;
        }
    }

    @Override
    public final void componentAdded(ContainerEvent e) {
        this.addComponent(e.getChild());
    }

    @Override
    public final void componentRemoved(ContainerEvent e) {
        this.removeComponent(e.getChild());
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
        this.propagateMouseEvent(e);
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        this.propagateMouseEvent(e);
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        this.propagateMouseEvent(e);
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        Point p;
        if (!this.allowUserInteraction) {
            return;
        }
        Object source = e.getSource();
        MovableObject mo = null;
        if (this.componentWithHandles != null && source instanceof Component && this.componentWithHandles.contains(p = SwingUtilities.convertPoint((Component)source, e.getX(), e.getY(), this.componentWithHandles))) {
            this.propagateMouseEvent(e);
            return;
        }
        mo = source instanceof MovableObject ? (MovableObject)source : (MovableObject)SwingUtilities.getAncestorOfClass(MovableObject.class, (Component)source);
        if (mo != null && mo != this.componentWithHandles) {
            if (this.componentWithHandles != null) {
                this.componentWithHandles.hideHandles();
            }
            this.componentWithHandles = mo;
            this.componentWithHandles.showHandles();
            this.requestFocus();
        }
        this.propagateMouseEvent(e);
    }

    @Override
    public final void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1005) {
            this.deselected();
        }
        super.processFocusEvent(e);
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        this.propagateMouseEvent(e);
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        this.propagateMouseMotionEvent(e);
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        this.propagateMouseMotionEvent(e);
    }

    public void setAllowUserInteraction(boolean allow) {
        this.allowUserInteraction = allow;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public void setAllowPopupMenus(boolean allow) {
        this.allowPopupMenus = allow;
    }

    public boolean getAllowPopupMenus() {
        return this.allowPopupMenus;
    }
}

