/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import jas.hist.Statistics;
import java.util.Observable;
import java.util.Random;

public class TestScatterPlotSource
extends Observable
implements ScatterPlotSource {
    private int delay = 0;
    protected double[] x;
    protected double[] y;
    private Random random = new Random();

    public TestScatterPlotSource(int delay) {
        this();
        this.delay = delay;
    }

    public TestScatterPlotSource() {
        this.x = new double[10000];
        this.y = new double[10000];
        for (int i = 0; i < 10000; ++i) {
            this.x[i] = this.random.nextGaussian();
            this.y[i] = this.random.nextGaussian() * 2.0;
        }
    }

    @Override
    public ScatterEnumeration startEnumeration() {
        return new TestEnumeration();
    }

    @Override
    public ScatterEnumeration startEnumeration(double a, double b, double c, double d) {
        return new TestEnumeration(a, b, c, d);
    }

    @Override
    public String getTitle() {
        return "Scatter Plot";
    }

    @Override
    public double getXMin() {
        return -3.0;
    }

    @Override
    public double getXMax() {
        return 3.0;
    }

    @Override
    public double getYMin() {
        return -6.0;
    }

    @Override
    public double getYMax() {
        return 6.0;
    }

    @Override
    public int getXAxisType() {
        return 1;
    }

    @Override
    public int getYAxisType() {
        return 1;
    }

    public Statistics getStatistics() {
        return null;
    }

    public void clearChanges() {
    }

    private class TestEnumeration
    implements ScatterEnumeration {
        private int n;
        private boolean limits;
        private double ymin;
        private double ymax;
        private double xmin;
        private double xmax;

        TestEnumeration() {
            this.n = 0;
            this.limits = false;
        }

        TestEnumeration(double xmin, double xmax, double ymin, double ymax) {
            this.n = 0;
            this.xmin = xmin;
            this.xmax = xmax;
            this.ymin = ymin;
            this.ymax = ymax;
            this.limits = true;
        }

        @Override
        public boolean getNextPoint(double[] d) {
            if (TestScatterPlotSource.this.delay > 0) {
                try {
                    Thread.sleep(TestScatterPlotSource.this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.limits) {
                while (this.n < 10000) {
                    if (TestScatterPlotSource.this.x[this.n] >= this.xmin && TestScatterPlotSource.this.x[this.n] < this.xmax && TestScatterPlotSource.this.y[this.n] >= this.ymin && TestScatterPlotSource.this.y[this.n] < this.ymax) {
                        d[0] = TestScatterPlotSource.this.x[this.n];
                        d[1] = TestScatterPlotSource.this.y[this.n];
                        ++this.n;
                        return true;
                    }
                    ++this.n;
                }
                return false;
            }
            if (this.n == 10000) {
                return false;
            }
            d[0] = TestScatterPlotSource.this.x[this.n];
            d[1] = TestScatterPlotSource.this.y[this.n];
            ++this.n;
            return true;
        }

        @Override
        public void resetEndPoint() {
        }

        @Override
        public void restart() {
            this.n = 0;
        }
    }
}

